/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ProcessPrinter;

public class VMFork {
    String cname;
    String[] args;
    String[] vmargs;
    String[] jars;
    String[] basejars;
    File dir;

    public static void main(String[] args) {
        System.out.println("Classpath separator = '" + VMFork.getClassPathSeparator() + "'");
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("memory")) {
                int n = 1024;
                try {
                    while (true) {
                        byte[] cfr_ignored_0 = new byte[n];
                        n *= 2;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Runtime.getRuntime();
                    System.out.println("<" + n / 1024 + "k");
                }
            }
            return;
        }
        try {
            VMFork fork = new VMFork("-version", null, new File("."));
            Process p = fork.fork();
            new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
            fork = new VMFork("VMFork", new String[]{"memory"}, new File("."));
            p = fork.fork();
            new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
            fork = new VMFork("VMFork", new String[]{"memory"}, new File("."));
            fork.setVMSpecificArgs(new String[]{"-Xmx512m"});
            p = fork.fork();
            new ProcessPrinter(p, System.out, System.err);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getJavaExe() {
        String jhome = System.getProperty("java.home");
        char c = File.separatorChar;
        StringBuffer java = new StringBuffer(jhome);
        java.append(c);
        java.append("bin");
        java.append(c);
        java.append("java");
        return java.toString();
    }

    private static String getClassPathSeparator() {
        String sep = System.getProperty("path.separator");
        return sep;
    }

    private static String getClassPath(String[] base_jars, String[] extra_jars) {
        int i;
        String classpath = System.getProperty("java.class.path");
        String sep = VMFork.getClassPathSeparator();
        if (base_jars != null) {
            classpath = "";
            i = 0;
            while (i < base_jars.length) {
                classpath = String.valueOf(classpath) + base_jars[i] + sep;
                ++i;
            }
        }
        if (extra_jars != null) {
            i = 0;
            while (i < extra_jars.length) {
                if (!classpath.endsWith(sep)) {
                    classpath = String.valueOf(classpath) + sep;
                }
                classpath = String.valueOf(classpath) + extra_jars[i];
                ++i;
            }
        }
        return classpath;
    }

    public VMFork(String cname) {
        this.cname = cname;
    }

    public VMFork(String cname, String[] args) {
        this.cname = cname;
        this.args = args;
    }

    public VMFork(String cname, String[] args, File working_dir) {
        this.cname = cname;
        this.args = args;
        this.dir = working_dir;
    }

    public void setClassName(String cname) {
        this.cname = cname;
    }

    public void setClassArgs(String[] args) {
        this.args = args;
    }

    public void setVMSpecificArgs(String[] args) {
        this.vmargs = args;
    }

    public void setClasspathExtras(String[] jars) {
        this.jars = jars;
    }

    public void setWorkingDir(File dir) {
        this.dir = dir;
    }

    public void setBaseClasspath(String[] jars) {
        this.basejars = jars;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            this.fork(sb);
        }
        catch (Exception e) {
            sb.append("VMFork problem: " + e);
        }
        return sb.toString();
    }

    public Process fork() throws IOException {
        return this.fork(null);
    }

    private Process fork(StringBuffer cmd) throws IOException {
        String java_exe = VMFork.getJavaExe();
        String classpath = VMFork.getClassPath(this.basejars, this.jars);
        if (this.args == null) {
            this.args = new String[0];
        }
        if (this.vmargs == null) {
            this.vmargs = new String[0];
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(java_exe);
        if (classpath.length() > 0) {
            commands.add("-cp");
            commands.add(classpath);
        }
        int i = 0;
        while (i < this.vmargs.length) {
            commands.add(this.vmargs[i]);
            ++i;
        }
        commands.add(this.cname);
        i = 0;
        while (i < this.args.length) {
            commands.add(this.args[i]);
            ++i;
        }
        String[] commands_array = new String[commands.size()];
        commands.toArray(commands_array);
        if (cmd == null) {
            Process p = Runtime.getRuntime().exec(commands_array, null, this.dir);
            return p;
        }
        int i2 = 0;
        while (i2 < commands_array.length) {
            cmd.append("CMD:" + commands_array[i2]).append("\n");
            ++i2;
        }
        return null;
    }
}

