/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FileMD5;
import org.eclipse.stp.b2j.core.misc.internal.HexData;

public class JARDependency
implements Serializable {
    private byte[] jar_dat;
    private String path;
    private String name;
    private boolean enabled = true;
    private String[] namespaces = null;
    private String plugin_name = null;

    public long size() {
        return this.jar_dat.length;
    }

    private JARDependency() {
    }

    public JARDependency(byte[] dat, String path) {
        this.jar_dat = dat;
        this.path = path;
        this.name = path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1);
    }

    public void setFilePath(String path) {
        this.path = path;
        this.name = path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1);
    }

    public String getFilePath() {
        return this.path;
    }

    public String getFileName() {
        return this.name;
    }

    public byte[] getJarData() {
        return this.jar_dat;
    }

    public void setPluginName(String name) {
        this.plugin_name = name;
    }

    public String getPluginName() {
        return this.plugin_name;
    }

    public void setAssociatedNamespaces(String[] namespaces) {
        this.namespaces = namespaces;
    }

    public String[] getAssociatedNamespaces() {
        return this.namespaces;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getCacheKey() throws IOException {
        return JARDependency.getJarDataCacheKey(this.jar_dat);
    }

    public static String getJarDataCacheKey(byte[] jar_dat) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            int N = 0;
            ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(jar_dat));
            ZipEntry zent = zin.getNextEntry();
            while (zent != null) {
                ++N;
                md.update(zent.getName().getBytes("UTF8"));
                byte[] buf = new byte[10000];
                int n = 0;
                while (n != -1) {
                    n = zin.read(buf, 0, 10000);
                    if (n <= 0) continue;
                    md.update(buf, 0, n);
                }
                zent = zin.getNextEntry();
            }
            zin.close();
            return String.valueOf(jar_dat.length) + "_" + FileMD5.md5ToString(md.digest());
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            IOException ee = new IOException("Failed to load MD5 algorithm");
            ee.initCause(e);
            throw ee;
        }
    }

    public static String toHex(JARDependency j) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        MessageWriter mwrite = new MessageWriter(bout);
        mwrite.write(JARDependency.toMessage(j));
        return HexData.byteArrayToHexString(bout.toByteArray());
    }

    public static JARDependency fromHex(String s) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(HexData.hexStringToByteArray(s));
        MessageReader mread = new MessageReader(bin);
        Message m = mread.read();
        return JARDependency.fromMessage(m);
    }

    public static Message toMessage(JARDependency j) {
        Message m = new Message();
        m.append(j.jar_dat);
        m.append(j.path);
        m.append(j.name);
        if (j.enabled) {
            m.append(1);
        } else {
            m.append(0);
        }
        return m;
    }

    public static JARDependency fromMessage(Message m) {
        JARDependency j = new JARDependency();
        j.jar_dat = (byte[])m.get(0);
        j.path = (String)m.get(1);
        j.name = (String)m.get(2);
        if (m.length() > 3) {
            j.enabled = (Integer)m.get(3) == 1;
        }
        return j;
    }

    public static JARDependency writeTemporaryDependency(JARDependency dep) throws IOException {
        File tmpjar = File.createTempFile("B2jEngineDependency_", ".jar");
        FileOutputStream fout = new FileOutputStream(tmpjar);
        fout.write(dep.jar_dat);
        fout.flush();
        fout.close();
        tmpjar.deleteOnExit();
        dep.path = tmpjar.getCanonicalPath();
        return dep;
    }
}

