/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELTranslatorException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockFlow;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockLock;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockObject;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockSync;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockThread;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;

public class LockModel {
    LockObject root = null;
    LockObject curr = null;
    HashMap syncMap = new HashMap();

    public LockModel(String rootThreadName) {
        LockFlow flow = new LockFlow(null);
        LockThread thread = new LockThread(flow, rootThreadName);
        flow.add(thread);
        this.root = flow;
        this.curr = thread;
    }

    private void push(LockObject obj) {
        this.curr.add(obj);
        this.curr = obj;
    }

    private LockObject pop(Util compiler_util, Node current) throws BPELTranslatorException {
        LockObject tmpcurr = this.curr;
        this.curr = this.curr.getParent();
        if (this.curr == null) {
            throw new BPELTranslatorException(compiler_util, current, "Popped too many from the LockModel");
        }
        return tmpcurr;
    }

    public void pushNewThreads(Util compiler_util, Node current) throws BPELTranslatorException {
        LockFlow flow = new LockFlow(this.curr);
        this.push(flow);
    }

    public void popThreads(Util compiler_util, Node current) throws BPELTranslatorException {
        if (!(this.pop(compiler_util, current) instanceof LockFlow)) {
            throw new BPELTranslatorException(compiler_util, current, "Expected to pop Threads but got something else instead");
        }
    }

    public void pushNewThread(Util compiler_util, Node current, String name) throws BPELTranslatorException {
        if (!(this.curr instanceof LockFlow)) {
            throw new BPELTranslatorException(compiler_util, current, "Tried to add new thread to something other than flow");
        }
        LockThread thread = new LockThread(this.curr, name);
        this.push(thread);
    }

    public void popThread(Util compiler_util, Node current) throws BPELTranslatorException {
        if (!(this.pop(compiler_util, current) instanceof LockThread)) {
            throw new BPELTranslatorException(compiler_util, current, "Expected to pop Thread but got something else instead");
        }
    }

    public void duplicatePreviousThread(Util compiler_util, Node current) throws BPELTranslatorException {
        LockFlow parent = (LockFlow)this.curr;
        LockThread prev = (LockThread)parent.getChild(parent.size() - 1);
        try {
            prev = (LockThread)prev.cloneDeep();
            prev.name = String.valueOf(prev.name) + "_dup";
            parent.add(prev);
        }
        catch (CloneNotSupportedException e) {
            throw new BPELTranslatorException(compiler_util, current, e);
        }
    }

    public void pushLock(Util compiler_util, Node current, String name) throws BPELTranslatorException {
        LockLock lock = new LockLock(this.curr, name);
        this.curr.addLock(lock);
    }

    public void pushSync(Util compiler_util, Node current, String lockName, String methodAlias, int from, int to) throws BPELTranslatorException {
        LockSync sync = new LockSync(this.curr, lockName, methodAlias, from, to);
        this.curr.addSync(sync);
        this.syncMap.put(methodAlias, sync);
    }

    public LockSync getSyncForMethodAlias(String methodAlias) {
        return (LockSync)this.syncMap.get(methodAlias);
    }

    public String toString() {
        return "\n" + this.root.toString(1, true);
    }

    public String toStringNoDisabled() {
        return "\n" + this.root.toString(1, false);
    }

    public LockObject getRoot() {
        return this.root;
    }
}

