/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClientTransport;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPFactory;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPUtils;

public class SOAPClient {
    public static void invokeOneWay(WSEndpointReference epr, BPELCorrelationSet cset, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction, String wsdl_message) throws Exception {
        try {
            SOAPClientTransport transport = SOAPFactory.getClientTransportForEPR(epr, cset, transportUri);
            if (rpc_type) {
                wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeRPC(wsdl_message, operationNamespace, operation);
                transport.send(wsdl_message, soapAction);
            } else {
                wsdl_message = SOAPUtils.basicWrapInSoapEnvelopeDocument(wsdl_message);
                transport.send(wsdl_message, soapAction);
            }
            transport.close();
        }
        catch (Exception e) {
            throw new SOAPException("SOAP Client Transaction Failed", wsdl_message, null, rpc_type, operationNamespace, operation, soapAction, e);
        }
    }

    public static String invokeRequestResponse(WSEndpointReference epr, BPELCorrelationSet cset, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction, String wsdl_message) throws Exception {
        String wsdl_response = null;
        try {
            SOAPClientTransport transport = SOAPFactory.getClientTransportForEPR(epr, cset, transportUri);
            wsdl_message = rpc_type ? SOAPUtils.basicWrapInSoapEnvelopeRPC(wsdl_message, operationNamespace, operation) : SOAPUtils.basicWrapInSoapEnvelopeDocument(wsdl_message);
            wsdl_response = transport.sendAndReceive(wsdl_message, soapAction);
            wsdl_response = rpc_type ? SOAPUtils.basicRemoveSoapEnvelopeRPC(wsdl_response) : SOAPUtils.basicRemoveSoapEnvelopeDocument(wsdl_response);
            transport.close();
            return wsdl_response;
        }
        catch (Exception e) {
            throw new SOAPException("SOAP Client Transaction Failed", wsdl_message, wsdl_response, rpc_type, operationNamespace, operation, soapAction, e);
        }
    }
}

