/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mutex;

import java.util.LinkedList;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;

public class QueuedSemaphore {
    private Object LOCK = new Object();
    private UnqueuedMutex SIGLOCK = new UnqueuedMutex();
    LinkedList counts = new LinkedList();
    int val = 0;

    public QueuedSemaphore(int initial) {
        this.val = initial - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(int count) {
        ThreadWait tw;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.val >= count) {
                this.val -= count;
                return;
            }
            this.val = 0;
            tw = new ThreadWait(count -= this.val);
            this.SIGLOCK.lock();
            this.counts.addLast(tw);
        }
        object = tw;
        synchronized (object) {
            this.SIGLOCK.release();
            try {
                tw.wait();
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSignal(int sig) {
        Object object = this.LOCK;
        synchronized (object) {
            this.val += sig;
            this.checkQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueue() {
        if (this.counts.isEmpty()) {
            return;
        }
        ThreadWait tw = (ThreadWait)this.counts.getFirst();
        int count = tw.count;
        while (this.val >= count) {
            this.val -= count;
            this.counts.removeFirst();
            this.SIGLOCK.lock();
            ThreadWait threadWait = tw;
            synchronized (threadWait) {
                tw.notify();
            }
            this.SIGLOCK.release();
            if (this.counts.isEmpty()) {
                return;
            }
            tw = (ThreadWait)this.counts.getFirst();
            count = tw.count;
        }
    }

    private class ThreadWait {
        int count;

        public ThreadWait(int n) {
            this.count = n;
        }
    }
}

