/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap;

import java.util.ArrayList;
import java.util.HashMap;


/**
 * 
 * @author amiguel
 *
 * A class to represent a BPEL partner link type, used in the translation 
 * of BPEL source files into engine Programs
 */
public class BPELPartnerLinkType {
	String name;
	HashMap roles_map = new HashMap();
	ArrayList roles_list = new ArrayList();
	
	public void addRole(BPELPartnerLinkRole role) {
		roles_map.put(role.name,role);
		roles_list.add(role);
	}
	public BPELPartnerLinkRole getRole(String name) {
		return (BPELPartnerLinkRole)roles_map.get(name);
	}
}