/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedBarrier;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 * 
 * Probably obsolete.
 * 
 * Part of the generic runtime engine API, represents the engine interface
 * available to a single thread in the engine Program execution.
 */
public abstract class RunnerInterface extends Thread {

public RunnerInterface(ThreadGroup group, String name) {
	super(group,name);	
}

public abstract void ipushStack(String stackline) throws Exception;
public abstract void ipushStack(Message stackinfo) throws Exception;
public abstract void ipopStack() throws Exception;

public abstract ClassLoader getProgramClassLoader();

public abstract String getStackTrace(Throwable t);

public abstract String[] getVariablesArray() throws Exception;

public abstract ArrayList getVariablesList() throws Exception;

/**
 * Get a hashmap to store data in which is local to this engine (instead of using static maps)
 */
public abstract HashMap getEngineLocalStorageMap(String name);

/**
 * Get an array containing all the hosts in this engine
 */
public abstract String[] getHostsArray() throws Exception;

/**
 * Get a list containing all the hosts in this engine
 */
public abstract ArrayList getHostsList() throws Exception;

/**
 *  Get the name of the current host as it appears in the host list
 */
public abstract String getHost() throws Exception;

/**
 * Get the hostname or ip address of the client that is connected to this engine
 * @return the hostname or ip address of the client that is connected to this engine
 * @throws Exception
 */
public abstract String getClientHost() throws Exception;

/**
 * Join with a remote runner (wait for it to die)
 * @param rid the ID of the runner to join with
 * @throws Exception
 */
public abstract void joinRunner(Long rid) throws Exception;

/**
 * Sends out a message on a conversation ID and receives a message on another
 * conversation ID
 * @param conversation
 * @param msg
 * @param conversationReturn
 * @return
 * @throws Exception
 */
public abstract Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn) throws Exception;

/**
 * Sends out a message on a conversation ID and receives one message on one or more other conversation IDs
 * NOTE: returned message will have a string appended to it to designate successful conversation
 * @param conversation
 * @param msg
 * @param conversationReturns
 * @return
 * @throws Exception
 */
public abstract Message sendAndReceiveMessage(String conversation, Message msg, String[] conversationReturns) throws Exception;

/**
 * Sends out a message on a particular conversation
 * @param conversation the ID of the conversation to send out on
 * @param m the message to send
 * @throws Exception
 */
public abstract void sendMessage(String conversation, Message m) throws Exception;

/**
 * Receives a message on a particular conversation
 * @param conversation the ID of the conversation to receive on
 * @return the received message
 * @throws Exception
 */
public abstract Message receiveMessage(String conversation) throws Exception;

/**
 * Receives a message on a particular conversation
 * @param conversation the ID of the conversation to receive on
 * @return the received message
 * @throws Exception
 */
public abstract Message receiveMessage(String conversation, long timeoutMS) throws Exception;

/**
 * Receives one message on one or more conversation IDs
 * @param conversations the IDs of the conversations to receive on
 * @return the received message
 * @throws Exception
 */
public abstract Message receiveMessage(String[] conversation) throws Exception;

/**
 * Receives one message on one or more conversation IDs
 * @param conversations the IDs of the conversations to receive on
 * @return the received message
 * @throws Exception
 */
public abstract Message receiveMessage(String[] conversation, long timeoutMS) throws Exception;

/**
 * Launch one or more runners on the the specified machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @param host the name of the host to run the Runners on
 * @return a Message of Long objects representing runner IDs (allows remote Join)
 */
public abstract Message launchRunner(int count, String method, int host_index) throws Exception; 

/**
 * Launch one or more runners on the the specified machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @param host the name of the host to run the Runners on
 * @param args a List of Strings to pass as arguments to the new Runner
 * @return a Message of Long objects representing runner IDs (allows remote Join)
 */
public abstract Message launchRunner(int count, String method, int host_index, List args) throws Exception; 

/**
 * Launch one or more runners on the the specified machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @param host the name of the host to run the Runners on
 * @param args a Message to pass as arguments to the new Runner
 * @return a Message of Long objects representing runner IDs (allows remote Join)
 */
public abstract Message launchRunner(int count, String method, int host_index, Message args) throws Exception; 

/**
 * Launch one or more runners on the the specified machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @param host the name of the host to run the Runners on
 * @param args a String[] to pass as list arguments to the new Runner
 * @return a Message of Long objects representing runner IDs (allows remote Join)
 */
public abstract Message launchRunner(int count, String method, int host_index, String[] args) throws Exception; 

/**
 * Launch one or more runners on the local machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @return an array of Thread objects to potentially join with
 */
public abstract ArrayList launchRunnerLocal(int count, String method) throws Exception; 

/**
 * Launch one or more runners on the local machine, having them run the specified method
 * @param count how many runners to launch
 * @param method the name of the program method to run
 * @param args an ArrayList of Strings to pass to the new Runner
 * @return an array of Thread objects to potentially join with
 */
public abstract ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception; 

/**
 * Asynchronously execute another program method (start a thread and get it to
 * run some other part of the program).  Method must return void and take an
 * ArrayList as its arguments.
 * NOTE: the difference between this and launchRunnerLocal is shared program memory (instance fields)
 * @param data the data to pass into the method
 * @return the Thread running another part of this program - this can be used to join with the thread
 */
public abstract Thread asyncProgramMethod(String method, ArrayList data) throws Exception;


/**
 * Create a new shared Semaphore
 */
public abstract SharedSemaphore newSemaphore(String name, int initial) throws Exception;

/**
 * Create a new barrier - used for barrier synchronisation
 */
public abstract SharedBarrier newBarrier(String name, int size) throws Exception;

/**
 * Create a new Mutex
 */
public abstract SharedMutex newMutex(String name) throws Exception;

/**
 * Create a new shared Variable
 * 
 * A variable can have two implementations.  
 * 
 * SOME NOTES ON DIRTY VARIABLE IMPLEMENTATION:
 * 
 * The first is a standard implementation
 * where a store always sends the data to the main controller and a fetch always
 * gets the data from the main controller.  In the standard (non-dirty) model, a
 * fetch or store operation will always cost 1 distributed transaction.  
 * 
 * The second 
 * implementation (dirty impl) means that a subcontroller holds a copy of the variables.
 * When a subcontroller stores a variable, all the non-dirty subcontrollers are told that they
 * are now dirty (the local value they hold is incorrect).  When a subcontroller fetches a variable,
 * if it is clean, it does no distributed operation.  If it is dirty, it fetches the variable from the
 * major controller and can now be considered clean.
 * 
 * The result of these implementations is that if a variable is frequently stored and fetched, the standard
 * implementation is more efficient since this means lots of notifies in the dirty model.
 * 
 * If, however, a variable is stored only infrequently and fetched frequently, the dirty model is far more
 * efficient, since most fetches will not involve any distributed transactions
 * 
 * SOME NOTES ON VARIABLE TYPES:
 *
 * A shared variable may have any of the types described in the SharedVariable class:
 *  	SharedVariable.INTEGER
 *  	SharedVariable.LONG
 *  	SharedVariable.FLOAT
 *  	SharedVariable.DOUBLE
 *  	SharedVariable.STRING
 *  	SharedVariable.BYTES
 *  	SharedVariable.MESSAGE
 *
 * @param name the name of this variable
 * @param type the type of this variable (as described above)
 * @param dirty whether this variable should use the dirty bit implementation
 */
public abstract SharedVariable newVariable(String name, int type, boolean dirty) throws Exception;

/**
 * Create a new shared HashMap
 */
public abstract SharedHashMap newHashMap(String name) throws Exception;

/**
 * Get an existing Semaphore by name
 * @param name the name of the already created shared Semaphore
 */
public abstract SharedSemaphore getSemaphore(String name) throws Exception;

/**
 * Get an existing Barrier by name
 * @param name the name of the already created shared Barrier
 */
public abstract SharedBarrier getBarrier(String name) throws Exception;

/**
 * Get an existing Mutex by name
 * @param name the name of the already created shared Mutex
 */
public abstract SharedMutex getMutex(String name) throws Exception;

/**
 * Get an existing Variable by name
 * @param name the name of the already created shared Variable
 */
public abstract SharedVariable getVariable(String name) throws Exception;

/**
 * Get an existing HashMap by name
 * @param name the name of the already created shared HashMap
 */
public abstract SharedHashMap getHashMap(String name) throws Exception;

/**
 * Trace a Message
 * @param m the Message
 */
public abstract void trace(Message m) throws Exception;

/**
 * Print a message (trace it) 
 * @param msg the String to print
 */
public abstract void print(String msg) throws Exception;

/**
 * Print any object (trace it) as a String
 * @param msg the Object to print (will be converted to a String)
 */
public abstract void print(Object msg) throws Exception;

/**
 * Print a debug message (on the engine debugging console) 
 * @param msg the debug String to print
 */
public abstract void debug(String msg) throws Exception;

/**
 * Get the runner ID
 * @return the ID of this runner (long)
 */
public abstract long getRunnerId();

/**
 * Get the runner ID as a Hex string
 * @return the hex ID of this runner (String)
 */
public abstract String getRunnerIdHex();

/**
 * Get the relative clock time
 * @return the clock time relative to the last sync
 */
public abstract long getClock();

/**
 * Terminate the entire engine
 */
public abstract void terminate() throws Exception;

}