/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * A utility class to manage server socket creation and usage in the TCPIPTransport
 * Session Transport extension
 */
public class ServerSocketPool {
	static Object pool_LOCK = new Object();
	static HashMap pool = new HashMap();
	
	public static ServerSocket getPooledServerSocket(int port) throws Exception {
		ServerSocket serv = null;
		synchronized(pool_LOCK) {
			serv = (ServerSocket)pool.get(new Integer(port));
			if (serv == null) {
				serv = new ServerSocket(port);
				pool.put(new Integer(port),serv);
			}
		}
		return serv;
	}
	public static ServerSocket getFreeServerSocket(int port_min, int port_max) throws Exception {
		ServerSocket serv = null;
		IOException last_error = null;
		
		if (port_min == SessionAddress.TRANSPORT_PORT_ANY) {
			port_min = 0;
		}
		if (port_max == SessionAddress.TRANSPORT_PORT_ANY) {
			port_max = 65535;
		}
		
		for (int i = port_min; serv == null && i <= port_max; i++) {
			try {
				serv = new ServerSocket(i);
			} catch (IOException e) {
				last_error = e;
				//failed to get this socket address
			}
		}
		if (serv == null) {
			throw new IOException("Failed to bind to any ports from "+port_min+" to "+port_max+" ("+last_error+")");
		}
		
		return serv;
	}
}