/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing a workbench host finding port
 */
public class DeploymentStrategyPort {
	public static final String DEPLOYMENT_STRATEGY_MAP_KEY = "DeploymentStrategy";
	public static final String DEPLOYMENT_STRATEGY_KEY = "DeploymentStrategy";
	public static final String DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY = "DeploymentStrategy.SpecificHostIndex";

	public static final Object DEPLOYMENT_STRATEGY_FIRST_HOST = new Object();
	public static final Object DEPLOYMENT_STRATEGY_EVEN_SPREAD = new Object();
	public static final Object DEPLOYMENT_STRATEGY_SPECIFIC_HOST = new Object();
	
	public void deployAllHostsEvenSpread() {
		setDeploymentStrategy(DEPLOYMENT_STRATEGY_EVEN_SPREAD);
	}
	public void deployOnFirstHost() {
		setDeploymentStrategy(DEPLOYMENT_STRATEGY_FIRST_HOST);
	}
	public void deployOnSpecificHost(int n) {
		setDeploymentStrategy(DEPLOYMENT_STRATEGY_SPECIFIC_HOST);
		setSpecificHostIndex(n);
	}

	public static int getSpecificHostIndex() {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;

			HashMap deploymentStrategy = engine.getEngineLocalStorageMap(DEPLOYMENT_STRATEGY_MAP_KEY);
		
			return ((Integer)deploymentStrategy.get(DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY)).intValue();
		}
		return 0;
	}
	
	public static Object getDeploymentStrategy() {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;

			HashMap deploymentStrategy = engine.getEngineLocalStorageMap(DEPLOYMENT_STRATEGY_MAP_KEY);
		
			return deploymentStrategy.get(DEPLOYMENT_STRATEGY_KEY);
		}
		return DEPLOYMENT_STRATEGY_EVEN_SPREAD;
	}
	public static void setDeploymentStrategy (Object o) {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;

			HashMap deploymentStrategy = engine.getEngineLocalStorageMap(DEPLOYMENT_STRATEGY_MAP_KEY);
			
			deploymentStrategy.put(DEPLOYMENT_STRATEGY_KEY,o);
		}
	}
	public static void setSpecificHostIndex (int n) {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;

			HashMap deploymentStrategy = engine.getEngineLocalStorageMap(DEPLOYMENT_STRATEGY_MAP_KEY);
			
			deploymentStrategy.put(DEPLOYMENT_STRATEGY_SPECIFIC_HOST_KEY,new Integer(n));
		}
	}
	
}