/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;

/**
 * @author amiguel
 * 
 * A class to serve transactions from a TransactionClient.
 *
 * The class immediately starts reading messages upon construction.
 * The user should implement TransactionListener and use the interface to
 * process messages and return the correct response.
 */
public class BPlaneTransactionServer implements MTTransactionServer {

MultiplexerOutputStream xout;
MultiplexerInputStream xin;

TransactionListener tl;

ThreadGroup tg;

/**
 * Construct a new TransactionServer around an input and output stream
 * @param bin the input stream to read messages on
 * @param bout the output stream to write message to
 * @param tl the TransactionListener which will process the transactions
 */
public BPlaneTransactionServer(InputStream bin, OutputStream bout, TransactionListener tl) {

	xin = new MultiplexerInputStream(bin,"BufferPlaneIncomingMultiplexer");
	xout = new MultiplexerOutputStream(bout,"BufferPlaneOutgoingMultiplexer");

	this.tl = tl;

	startPlaneListener((short)0);

}//end constructor

/**
 * Construct a new TransactionServer around an input and output stream
 * @param bin the input stream to read messages on
 * @param bout the output stream to write message to
 * @param tl the TransactionListener which will process the transactions
 */
public BPlaneTransactionServer(InputStream bin, OutputStream bout, TransactionListener tl, ThreadGroup tg, String name) {

	xin = new MultiplexerInputStream(bin,name+"_BufferPlaneIncomingMultiplexer",tg);
	xout = new MultiplexerOutputStream(bout,name+"_BufferPlaneOutgoingMultiplexer",tg);

	this.tl = tl;
	this.tg = tg;

	startPlaneListener((short)0);

}//end constructor

void startPlaneListener(short plane) {
	BPlaneServerThread bpt = new BPlaneServerThread(this,plane);
//	bpt.setDaemon(true);
	bpt.setName("Buffer Plane Server Listener (plane "+plane+")");
	bpt.start();
}

}//end class
