/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.ArrayList;

/**
 * 
 * @author amiguel
 *
 * A runtime class used to implement XPATH expression
 */
public class XNodeSet {
ArrayList list = null;

	public XNodeSet() {
		list = new ArrayList();
	}
	public XNodeSet(int n) {
		list = new ArrayList(n+7);
	}
	public void add(XNode node) {
		list.add(node);
	}
	public void addAll(XNodeSet nodeset) {
		list.addAll(nodeset.list);
	}
	public XNode get(int i) {
		return (XNode)list.get(i);
	}
	public int size() {
		return list.size();
	}
	
	public String toString() {
		int size = size();
		
		if (size == 0) {
			//common case optimisation 1
			return "";
		} else if (size == 1) {
			//common case optimisation 2
			return get(0).toString();
		}
		
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < size(); i++) {
			sb.append(get(i).toString());
		}
		return sb.toString();
	}
	
	public Double toNumber() {
		if (size() == 1) {
			//common case optimisation
			Double d = get(0).getValue().toXpathNumber();
			if (d != null) {
				return d;
			}
		}
		
		return new Double(toString());
	}
}