/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.example;

import java.io.FileInputStream;
import java.io.ObjectInputStream;

import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.engine.IndependantLocalBPELEngine;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;

public class RuntimeOnlyExecuteExample {

	private static void usage() {
		System.out.println("Usage: RuntimeOnlyExecuteExample <file>");
		System.out.println("");
		System.out.println("e.g. RuntimeOnlyCompileExample mytest.bpel  (requires full JAR)");
		System.out.println("     RuntimeOnlyExecuteExample mytest.bpel.b2jprog  (requires runtime only JAR)");
		System.exit(1);
	}
	
	public static void main(String[] args) throws Exception {
		
		if (args.length < 1) {
			usage();
		}
		
		String file = args[0];

		ObjectInputStream oin = new ObjectInputStream(new FileInputStream(file));
		BPELProgram program = (BPELProgram)oin.readObject();
		oin.close();

		IndependantLocalBPELEngine engine = new IndependantLocalBPELEngine(program);
		engine.runProgram(new PrintoutEngineListener(), false, false, true);
		engine.waitForProgramCompletion();
	}
	
	private static class PrintoutEngineListener implements BPELEngineListener {

		public void printInfo(String s) {
			System.out.println("INFO: "+s);
		}

		public void printDebug(String s) {
			System.out.println("DEBUG: "+s);
		}

		public void printEngineInfo(String s) {
			System.out.println("ENGINE_INFO: "+s);
		}

		public void printEngineDebug(String s) {
			System.out.println("ENGINE_DEBUG: "+s);
		}
		
	}
	
}