/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * Represents a stackframe in a runner in the engine
 */
public class RunnerDebugVariable extends ControllerDebugElement implements IVariable {
	RunnerStackFrame frame;
	ControllerInterface engine;
	
	String name;
	
	public RunnerDebugVariable(RunnerStackFrame frame, String name) {
		super((ControllerDebugTarget)frame.getDebugTarget());
		this.frame = frame;
		this.engine = ((ControllerDebugTarget)getDebugTarget()).engine;
		this.name = name;
	}

	public IValue getValue() throws DebugException {
		try {
			SharedVariable var = engine.getVariable(BPELVariable.PREFIX+name);
			var.varFetch();
			Message value = var.getValueMessage();
			return new RunnerDebugVariableValue(this,value);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public String getName() throws DebugException {
		return name;
	}

	public String getReferenceTypeName() throws DebugException {
		return getValue().getReferenceTypeName();
	}

	public boolean hasValueChanged() throws DebugException {
		// TODO Auto-generated method stub
		return false;
	}

	public void setValue(String expression) throws DebugException {
		// TODO Auto-generated method stub
		
	}

	public void setValue(IValue value) throws DebugException {
		// TODO Auto-generated method stub
		
	}

	public boolean supportsValueModification() {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean verifyValue(String expression) throws DebugException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean verifyValue(IValue value) throws DebugException {
		// TODO Auto-generated method stub
		return false;
	}
	

}