/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolPoolCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private ZoomManager _zoom;
    private static final int AVOID_INTERVAL = 1;
    public static final Insets INSETS = new Insets(PoolPoolCompartmentEditPart.INSETS);

    public void activate() {
        super.activate();
        this._zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        this.fillMapAndSet(map, set, request, resize);
        if (map.isEmpty()) {
            CompoundCommand negativeCommand = this.chunkNegativeMove(request);
            if (negativeCommand != null) {
                return negativeCommand;
            }
            CompoundCommand command = new CompoundCommand();
            command.add(super.getResizeChildrenCommand(request));
            boolean unexec = this.avoidOverlap(request, command);
            if (unexec) {
                return UnexecutableCommand.INSTANCE;
            }
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
            req.setEditParts(this.getHost().getParent());
            req.setCenteredResize(true);
            req.setSizeDelta(this.getMinSizeForPool(request));
            command.add(this.getHost().getParent().getParent().getCommand((Request)req));
            this.makeSnapBackCommands(command, request);
            return command;
        }
        this.doLayout(request, map, set, resize, null);
        this.makeSnapBackCommands(resize, request);
        return resize.unwrap();
    }

    protected boolean avoidOverlap(IGraphicalEditPart movedPart, Rectangle requestedNewBounds, IGraphicalEditPart overlappingPart, CompoundCommand theCommand) {
        return true;
    }

    private Point divideByZoom(Point p) {
        p.x = (int)Math.floor((double)p.x / this._zoom.getZoom());
        p.y = (int)Math.floor((double)p.y / this._zoom.getZoom());
        return p;
    }

    private Dimension divideByZoom(Dimension p) {
        p.width = (int)Math.floor((double)p.width / this._zoom.getZoom());
        p.height = (int)Math.floor((double)p.height / this._zoom.getZoom());
        return p;
    }

    private boolean avoidOverlap(ChangeBoundsRequest request, CompoundCommand compound) {
        HashMap<IGraphicalEditPart, Rectangle> old2newBounds = new HashMap<IGraphicalEditPart, Rectangle>();
        Dimension sizeDelta = this.divideByZoom(new Dimension(request.getSizeDelta()));
        Point moveDelta = this.divideByZoom(new Point(request.getMoveDelta()));
        for (Object ep : request.getEditParts()) {
            Rectangle rect = ((IGraphicalEditPart)ep).getFigure().getBounds().getCopy();
            Rectangle newRect = rect.resize(sizeDelta).translate(moveDelta);
            old2newBounds.put((IGraphicalEditPart)ep, newRect);
        }
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)child;
            if (request.getEditParts().contains(part)) continue;
            Rectangle childInnerBounds = new Rectangle(part.getFigure().getBounds());
            childInnerBounds.shrink(4, 4);
            for (Map.Entry bounds : old2newBounds.entrySet()) {
                boolean r;
                Rectangle requestedNewBounds = (Rectangle)old2newBounds.get(bounds.getKey());
                if (!requestedNewBounds.intersects(childInnerBounds) || !(r = this.avoidOverlap((IGraphicalEditPart)bounds.getKey(), requestedNewBounds, part, compound))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAlignedOnY(Rectangle bounds, Rectangle childBounds) {
        int y1 = bounds.y;
        int y2 = bounds.y + bounds.height;
        if (childBounds.y >= y1 && childBounds.y <= y2) {
            return true;
        }
        int childBoundsy2 = childBounds.height + childBounds.y;
        return childBoundsy2 >= y1 && childBoundsy2 <= y2;
    }

    private boolean isAlignedOnX(Rectangle bounds, Rectangle childBounds) {
        int x1 = bounds.x;
        int x2 = bounds.x + bounds.width;
        if (childBounds.x >= x1 && childBounds.x <= x2) {
            return true;
        }
        int childBoundsx2 = childBounds.width + childBounds.x;
        return childBoundsx2 >= x1 && childBoundsx2 <= x2;
    }

    private Dimension getMinSizeForPool(CreateRequest request) {
        Dimension requestSize;
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(Collections.EMPTY_LIST);
        Dimension dim = this.getMinSizeForPool(req);
        Dimension dimension = requestSize = request.getSize() == null ? null : request.getSize().getCopy();
        if (requestSize == null) {
            CreateViewRequest.ViewDescriptor desc;
            List descriptors;
            requestSize = new Dimension(300, 100);
            if (request instanceof CreateViewRequest && !(descriptors = ((CreateViewRequest)request).getViewDescriptors()).isEmpty() && (desc = (CreateViewRequest.ViewDescriptor)descriptors.get(0)).getElementAdapter() != null) {
                IElementType type = (IElementType)desc.getElementAdapter().getAdapter(IElementType.class);
                requestSize = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
            }
        }
        Dimension initialdim = ((GraphicalEditPart)this.getHost()).getFigure().getSize().getCopy();
        Point loc = request.getLocation().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)loc);
        Rectangle rect = this.getHostFigure().getParent().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        loc.x -= rect.x;
        loc.y -= rect.y;
        dim.width = Math.max(dim.width, loc.x + requestSize.width - initialdim.width + INSETS.getWidth());
        dim.height = Math.max(dim.height, loc.y + requestSize.height - initialdim.height + INSETS.getHeight());
        return dim;
    }

    private Dimension getMinSizeForPool(ChangeBoundsRequest request) {
        Dimension initialdim = ((GraphicalEditPart)this.getHost()).getFigure().getSize().getCopy();
        Dimension dim = new Dimension(0, 0);
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)child;
            Rectangle r = part.getFigure().getBounds().getCopy();
            int w = r.x + r.width;
            if (request.getEditParts().contains(part)) {
                w += request.getSizeDelta().width + request.getMoveDelta().x;
                w += 300;
            }
            if (dim.width < w) {
                dim.width = w;
            }
            int h = r.y + r.height;
            if (request.getEditParts().contains(part)) {
                h += request.getSizeDelta().height + request.getMoveDelta().y;
            }
            if (dim.height >= h) continue;
            dim.height = h;
        }
        dim.width = dim.width - initialdim.width + INSETS.getWidth();
        dim.height = dim.height - initialdim.height + INSETS.getHeight();
        if (dim.width < 0) {
            dim.width = 0;
        }
        if (dim.height < 0) {
            dim.height = 0;
        }
        return dim;
    }

    private void fillMapAndSet(Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> orderedLaneBounds, ChangeBoundsRequest request, CompoundCommand cc) {
        List children = request != null ? request.getEditParts() : Collections.EMPTY_LIST;
        List allChildren = this.getHost().getChildren();
        for (IGraphicalEditPart child : allChildren) {
            int x = 0;
            if (child instanceof LaneEditPart && child.resolveSemanticElement().eResource() != null) {
                Rectangle bounds;
                if (children.contains(child)) {
                    bounds = (Rectangle)this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child));
                    bounds.x = x;
                } else {
                    int y = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    int width = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                    int height = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                    bounds = new Rectangle(x, y, width, height);
                }
                map.put(child, bounds);
                orderedLaneBounds.add(bounds);
                continue;
            }
            if (!children.contains(child)) continue;
            Command c = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child)));
            cc.add(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doLayout(ChangeBoundsRequest request, Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> set, CompoundCommand cc, Set<Rectangle> insertedRectangles) {
        if (request != null && request.getEditParts() != null && request.getEditParts().size() == 1 && request.getEditParts().get(0) instanceof PoolEditPart) {
            PoolEditPart container = (PoolEditPart)((Object)request.getEditParts().get(0));
            if (container != this.getHost().getParent() || request.getSizeDelta().height == 0) return;
            Rectangle r = null;
            if (request.getMoveDelta().y != 0) {
                Iterator it = set.iterator();
                r = (Rectangle)it.next();
                r.setSize(r.width, r.height + request.getSizeDelta().height);
                if (it.hasNext()) {
                    Rectangle second = (Rectangle)it.next();
                    second.y = r.y + r.height;
                }
            } else {
                r = set.last();
                r.setSize(r.width, r.height + request.getSizeDelta().height);
            }
        } else if (request != null) {
            if (request.getMoveDelta().y != 0 && request.getSizeDelta().height == -request.getMoveDelta().y) {
                LinkedList<Rectangle> rects = new LinkedList<Rectangle>(set);
                Rectangle prevLast = null;
                while (!rects.isEmpty()) {
                    Rectangle last = rects.removeLast();
                    if (prevLast != null && prevLast.y != last.y + last.height) {
                        int cfr_ignored_0 = last.y;
                        int cfr_ignored_1 = last.y + last.height;
                        last.height = prevLast.y - last.y;
                        if (last.height <= 48) {
                            last.height = 48;
                            int prevBottomY = prevLast.y + prevLast.height;
                            prevLast.y = last.y + last.height;
                            prevLast.height = prevBottomY - prevLast.y;
                        }
                    }
                    prevLast = last;
                }
            } else {
                Rectangle firstBounds = null;
                for (Rectangle secondBounds : set) {
                    if (firstBounds != null && firstBounds.y + firstBounds.height != secondBounds.y || secondBounds.y != PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top) {
                        int heightDelta = -secondBounds.y;
                        if (firstBounds == null) {
                            secondBounds.setLocation(0, PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top);
                        } else {
                            secondBounds.setLocation(0, firstBounds.y + firstBounds.height);
                        }
                        secondBounds.setSize(secondBounds.width, secondBounds.height - (heightDelta += secondBounds.y));
                    }
                    firstBounds = secondBounds;
                }
                Point bottomLane = firstBounds.getBottom();
                Point bottomPool = this.getHostFigure().getBounds().getBottom();
                if (bottomLane.y != bottomPool.y - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.bottom) {
                    firstBounds.setSize(firstBounds.width, firstBounds.height + bottomPool.y - bottomLane.y - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.bottom);
                }
            }
        }
        Set<Map.Entry<IGraphicalEditPart, Rectangle>> entries = map.entrySet();
        for (Map.Entry<IGraphicalEditPart, Rectangle> outerEntry : entries) {
            IGraphicalEditPart pep = outerEntry.getKey();
            Rectangle rect = outerEntry.getValue();
            Rectangle prevBounds = pep.getFigure().getBounds();
            if (prevBounds.equals((Object)rect)) continue;
            Command c = this.createChangeConstraintCommand((EditPart)pep, rect);
            cc.add(c);
        }
    }

    protected Command getCreateCommand(CreateRequest request) {
        Point loc = request.getLocation().getCopy();
        Point here = this.getHostFigure().getBounds().getCopy().getLocation();
        this.getHostFigure().translateToAbsolute((Translatable)loc);
        this.getHostFigure().translateToAbsolute((Translatable)here);
        if (this.getHost().getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
            loc.x = (int)((double)loc.x / zoom.getZoom());
            loc.y = (int)((double)loc.y / zoom.getZoom());
        }
        loc.x -= here.x;
        loc.y -= here.y;
        if (loc.x < PoolPoolCompartmentXYLayoutEditPolicy.INSETS.left) {
            int correction = PoolPoolCompartmentXYLayoutEditPolicy.INSETS.left - loc.x + 1;
            if (correction < 0) {
                correction = 0;
            }
            request.getLocation().x += correction;
        }
        if (loc.y < PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top) {
            int correction = PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top - loc.y;
            if (correction < 0) {
                correction = 0;
            }
            request.getLocation().y += correction;
        }
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, BpmnDiagramMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        this.fillMapAndSet(map, set, null, null);
        HashMap<CreateViewRequest.ViewDescriptor, Rectangle> descriptorsMap = new HashMap<CreateViewRequest.ViewDescriptor, Rectangle>();
        HashSet<Rectangle> insertedRectangles = null;
        while (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            if (viewDescriptor.getSemanticHint() != null && viewDescriptor.getSemanticHint().equals(String.valueOf(2007))) {
                rect.x = 0;
                Point location = req.getLocation().getCopy();
                this.getHostFigure().translateToRelative((Translatable)location);
                int ind = 0;
                for (Rectangle otherLane : set) {
                    if (otherLane.y < location.y && otherLane.y + otherLane.height >= location.y) {
                        otherLane.height /= 2;
                        rect.height = otherLane.height;
                        if (otherLane.y + otherLane.height >= location.y) {
                            rect.y = otherLane.y;
                            otherLane.y += rect.height + 2;
                            break;
                        }
                        rect.y = otherLane.y + rect.height + 2;
                        break;
                    }
                    ++ind;
                }
                if (insertedRectangles == null) {
                    insertedRectangles = new HashSet<Rectangle>();
                }
                if (ind == set.size()) {
                    rect.y = PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top;
                    rect.height = this.getHostFigure().getBounds().height - PoolPoolCompartmentEditPart.INSETS.top - PoolPoolCompartmentEditPart.INSETS.bottom;
                }
                insertedRectangles.add(rect);
            }
            descriptorsMap.put(viewDescriptor, rect);
        }
        if (insertedRectangles != null) {
            set.addAll(insertedRectangles);
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        this.doLayout(null, map, set, compoundCommand, insertedRectangles);
        if (compoundCommand.canExecute()) {
            cc.compose((IUndoableOperation)new CommandProxy((Command)compoundCommand));
        }
        for (Map.Entry entry : descriptorsMap.entrySet()) {
            cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, BpmnDiagramMessages.SetLocationCommand_Label_Resize, (IAdaptable)entry.getKey(), (Rectangle)entry.getValue()));
        }
        ChangeBoundsRequest thisSizeReq = new ChangeBoundsRequest((Object)"resize children");
        thisSizeReq.setEditParts(this.getHost().getParent());
        thisSizeReq.setCenteredResize(true);
        thisSizeReq.setSizeDelta(this.getMinSizeForPool(request));
        Command diagCo = this.getHost().getParent().getParent().getCommand((Request)thisSizeReq);
        if (diagCo != null) {
            cc.compose((IUndoableOperation)new CommandProxy(diagCo));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }

    private CompoundCommand chunkNegativeMove(ChangeBoundsRequest request) {
        if (request == null) {
            return null;
        }
        boolean isNegative = false;
        Point maxMove = new Point(request.getMoveDelta().x, request.getMoveDelta().y);
        for (Object ep : request.getEditParts()) {
            int ymove;
            Point loc = ((GraphicalEditPart)ep).getFigure().getBounds().getLocation().getCopy();
            int xmove = loc.x + request.getMoveDelta().x - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.left;
            if (xmove <= 0) {
                maxMove.x = -loc.x + PoolPoolCompartmentXYLayoutEditPolicy.INSETS.left;
                isNegative = true;
            }
            if ((ymove = loc.y + request.getMoveDelta().y - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top) > 0) continue;
            maxMove.y = -loc.y + PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top;
            isNegative = true;
        }
        Point p = new Point(request.getMoveDelta().x - maxMove.x, request.getMoveDelta().y - maxMove.y);
        request.setMoveDelta(maxMove);
        if (isNegative) {
            int toobigy = request.getMoveDelta().y + request.getSizeDelta().height;
            int maxHeight = 0;
            for (Object ep : request.getEditParts()) {
                maxHeight = Math.max(maxHeight, ((GraphicalEditPart)ep).getFigure().getBounds().height + ((GraphicalEditPart)ep).getFigure().getBounds().y);
            }
            if (this.getHostFigure().getBounds().height < toobigy + maxHeight) {
                isNegative = false;
            }
        }
        if (isNegative) {
            int toobigx = request.getMoveDelta().x + request.getSizeDelta().width;
            int maxWidth = 0;
            for (Object ep : request.getEditParts()) {
                maxWidth = Math.max(maxWidth, ((GraphicalEditPart)ep).getFigure().getBounds().width + ((GraphicalEditPart)ep).getFigure().getBounds().x);
            }
            if (this.getHostFigure().getBounds().width < toobigx + maxWidth) {
                isNegative = false;
            }
        }
        if (!isNegative) {
            return null;
        }
        ChangeBoundsRequest compartmentRequest = new ChangeBoundsRequest((Object)"resize children");
        Dimension d = new Dimension(Math.abs(p.x), Math.abs(p.y));
        compartmentRequest.setMoveDelta(new Point(0, 0));
        compartmentRequest.setSizeDelta(d);
        compartmentRequest.setEditParts(this.getHost().getParent());
        ChangeBoundsRequest childrenRequest = new ChangeBoundsRequest((Object)"move children");
        Point childrenMove = new Point(d.width, d.height);
        childrenRequest.setMoveDelta(childrenMove);
        ArrayList childrenToMove = new ArrayList();
        for (Object child : this.getHost().getChildren()) {
            Location b;
            if (request.getEditParts().contains(child) || child instanceof IGraphicalEditPart && ((IGraphicalEditPart)child).getNotationView() instanceof Node && (b = (Location)((Node)((IGraphicalEditPart)child).getNotationView()).getLayoutConstraint()).getX() == -1 && b.getY() == -1) continue;
            childrenToMove.add(child);
        }
        childrenRequest.setEditParts(childrenToMove);
        CompoundCommand co = new CompoundCommand();
        co.add(super.getResizeChildrenCommand(request));
        Command comm = this.getHost().getParent().getParent().getCommand((Request)compartmentRequest);
        co.add(comm);
        if (!(childrenRequest.getEditParts().isEmpty() || childrenRequest.getMoveDelta().x == 0 && childrenRequest.getMoveDelta().y == 0)) {
            co.add(this.getHost().getCommand((Request)childrenRequest));
        }
        return co;
    }

    private void makeSnapBackCommands(CompoundCommand compound, ChangeBoundsRequest request) {
        for (Object epObj : request.getEditParts()) {
            if (!(epObj instanceof AbstractGraphicalEditPart)) continue;
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getSourceConnections(), compound);
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getTargetConnections(), compound);
        }
    }

    private void iterateOverConnections(List connections, CompoundCommand compound) {
        Request snapBack = new Request((Object)"snap_back");
        for (Object con : connections) {
            if (!(con instanceof ConnectionEditPart)) continue;
            LabelEditPart label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4012));
            if (label == null) {
                label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4013));
            }
            if (label == null) continue;
            compound.add(label.getCommand(snapBack));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RectanglesComparator
    implements Comparator<Rectangle> {
        private RectanglesComparator() {
        }

        @Override
        public int compare(Rectangle r1, Rectangle r2) {
            if (r1.y > r2.y) {
                return 1;
            }
            if (r1.y < r2.y) {
                return -1;
            }
            return 0;
        }
    }
}

