/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.stp.bpmn.BpmnMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ActivityType implements Enumerator
{
    TASK_LITERAL(0, BpmnMessages.ActivityType_task, "Task"),
    SUB_PROCESS_LITERAL(1, BpmnMessages.ActivityType_sub_process, "SubProcess"),
    EVENT_START_EMPTY_LITERAL(2, BpmnMessages.ActivityType_start_empty, "EventStartEmpty"),
    EVENT_START_MESSAGE_LITERAL(3, BpmnMessages.ActivityType_start_message, "EventStartMessage"),
    EVENT_START_RULE_LITERAL(4, BpmnMessages.ActivityType_start_rule, "EventStartRule"),
    EVENT_START_TIMER_LITERAL(5, BpmnMessages.ActivityType_start_timer, "EventStartTimer"),
    EVENT_START_LINK_LITERAL(6, BpmnMessages.ActivityType_start_link, "EventStartLink"),
    EVENT_START_MULTIPLE_LITERAL(7, BpmnMessages.ActivityType_start_multiple, "EventStartMultiple"),
    EVENT_INTERMEDIATE_EMPTY_LITERAL(8, BpmnMessages.ActivityType_intermediate_empty, "EventIntermediateEmpty"),
    EVENT_INTERMEDIATE_MESSAGE_LITERAL(9, BpmnMessages.ActivityType_intermediate_message, "EventIntermediateMessage"),
    EVENT_INTERMEDIATE_TIMER_LITERAL(10, BpmnMessages.ActivityType_intermediate_timer, "EventIntermediateTimer"),
    EVENT_INTERMEDIATE_ERROR_LITERAL(11, BpmnMessages.ActivityType_intermediate_error, "EventIntermediateError"),
    EVENT_INTERMEDIATE_COMPENSATION_LITERAL(12, BpmnMessages.ActivityType_intermediate_compensation, "EventIntermediateCompensation"),
    EVENT_INTERMEDIATE_RULE_LITERAL(13, BpmnMessages.ActivityType_intermediate_rule, "EventIntermediateRule"),
    EVENT_INTERMEDIATE_LINK_LITERAL(14, BpmnMessages.ActivityType_intermediate_link, "EventIntermediateLink"),
    EVENT_INTERMEDIATE_MULTIPLE_LITERAL(15, BpmnMessages.ActivityType_intermediate_multiple, "EventIntermediateMultiple"),
    EVENT_INTERMEDIATE_CANCEL_LITERAL(16, BpmnMessages.ActivityType_intermediate_cancel, "EventIntermediateCancel"),
    EVENT_END_EMPTY_LITERAL(17, BpmnMessages.ActivityType_end_empty, "EventEndEmpty"),
    EVENT_END_MESSAGE_LITERAL(18, BpmnMessages.ActivityType_end_message, "EventEndMessage"),
    EVENT_END_ERROR_LITERAL(19, BpmnMessages.ActivityType_end_error, "EventEndError"),
    EVENT_END_COMPENSATION_LITERAL(20, BpmnMessages.ActivityType_end_compensation, "EventEndCompensation"),
    EVENT_END_TERMINATE_LITERAL(21, BpmnMessages.ActivityType_end_terminate, "EventEndTerminate"),
    EVENT_END_LINK_LITERAL(22, BpmnMessages.ActivityType_end_link, "EventEndLink"),
    EVENT_END_MULTIPLE_LITERAL(23, BpmnMessages.ActivityType_end_multiple, "EventEndMultiple"),
    EVENT_END_CANCEL_LITERAL(24, BpmnMessages.ActivityType_end_cancel, "EventEndCancel"),
    GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL(25, BpmnMessages.ActivityType_xor, "GatewayDataBasedExclusive"),
    GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL(26, BpmnMessages.ActivityType_xor_events, "GatewayEventBasedExclusive"),
    GATEWAY_DATA_BASED_INCLUSIVE_LITERAL(27, BpmnMessages.ActivityType_or, "GatewayDataBasedInclusive"),
    GATEWAY_PARALLEL_LITERAL(28, BpmnMessages.ActivityType_parallel, "GatewayParallel"),
    GATEWAY_COMPLEX_LITERAL(29, BpmnMessages.ActivityType_complex, "GatewayComplex");

    public static final int TASK = 0;
    public static final int SUB_PROCESS = 1;
    public static final int EVENT_START_EMPTY = 2;
    public static final int EVENT_START_MESSAGE = 3;
    public static final int EVENT_START_RULE = 4;
    public static final int EVENT_START_TIMER = 5;
    public static final int EVENT_START_LINK = 6;
    public static final int EVENT_START_MULTIPLE = 7;
    public static final int EVENT_INTERMEDIATE_EMPTY = 8;
    public static final int EVENT_INTERMEDIATE_MESSAGE = 9;
    public static final int EVENT_INTERMEDIATE_TIMER = 10;
    public static final int EVENT_INTERMEDIATE_ERROR = 11;
    public static final int EVENT_INTERMEDIATE_COMPENSATION = 12;
    public static final int EVENT_INTERMEDIATE_RULE = 13;
    public static final int EVENT_INTERMEDIATE_LINK = 14;
    public static final int EVENT_INTERMEDIATE_MULTIPLE = 15;
    public static final int EVENT_INTERMEDIATE_CANCEL = 16;
    public static final int EVENT_END_EMPTY = 17;
    public static final int EVENT_END_MESSAGE = 18;
    public static final int EVENT_END_ERROR = 19;
    public static final int EVENT_END_COMPENSATION = 20;
    public static final int EVENT_END_TERMINATE = 21;
    public static final int EVENT_END_LINK = 22;
    public static final int EVENT_END_MULTIPLE = 23;
    public static final int EVENT_END_CANCEL = 24;
    public static final int GATEWAY_DATA_BASED_EXCLUSIVE = 25;
    public static final int GATEWAY_EVENT_BASED_EXCLUSIVE = 26;
    public static final int GATEWAY_DATA_BASED_INCLUSIVE = 27;
    public static final int GATEWAY_PARALLEL = 28;
    public static final int GATEWAY_COMPLEX = 29;
    private static final ActivityType[] VALUES_ARRAY;
    private static final ActivityType[] VALUES_EVENTS_ARRAY;
    private static final ActivityType[] VALUES_GATEWAYS_ARRAY;
    private static final ActivityType[] VALUES_EVENTS_INTERMEDIATE_ARRAY;
    private static final ActivityType[] VALUES_EVENTS_START_ARRAY;
    public static final List<ActivityType> VALUES;
    public static final List VALUES_EVENTS;
    public static final List VALUES_EVENTS_INTERMEDIATE;
    public static final List VALUES_EVENTS_START;
    public static final List VALUES_GATEWAYS;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivityType[]{TASK_LITERAL, SUB_PROCESS_LITERAL, EVENT_START_EMPTY_LITERAL, EVENT_START_MESSAGE_LITERAL, EVENT_START_RULE_LITERAL, EVENT_START_TIMER_LITERAL, EVENT_START_LINK_LITERAL, EVENT_START_MULTIPLE_LITERAL, EVENT_INTERMEDIATE_EMPTY_LITERAL, EVENT_INTERMEDIATE_MESSAGE_LITERAL, EVENT_INTERMEDIATE_TIMER_LITERAL, EVENT_INTERMEDIATE_ERROR_LITERAL, EVENT_INTERMEDIATE_COMPENSATION_LITERAL, EVENT_INTERMEDIATE_RULE_LITERAL, EVENT_INTERMEDIATE_LINK_LITERAL, EVENT_INTERMEDIATE_MULTIPLE_LITERAL, EVENT_INTERMEDIATE_CANCEL_LITERAL, EVENT_END_EMPTY_LITERAL, EVENT_END_MESSAGE_LITERAL, EVENT_END_ERROR_LITERAL, EVENT_END_COMPENSATION_LITERAL, EVENT_END_TERMINATE_LITERAL, EVENT_END_LINK_LITERAL, EVENT_END_MULTIPLE_LITERAL, EVENT_END_CANCEL_LITERAL, GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL, GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL, GATEWAY_DATA_BASED_INCLUSIVE_LITERAL, GATEWAY_PARALLEL_LITERAL, GATEWAY_COMPLEX_LITERAL};
        VALUES_EVENTS_ARRAY = new ActivityType[]{EVENT_START_EMPTY_LITERAL, EVENT_START_MESSAGE_LITERAL, EVENT_START_RULE_LITERAL, EVENT_START_LINK_LITERAL, EVENT_START_MULTIPLE_LITERAL, EVENT_START_TIMER_LITERAL, EVENT_INTERMEDIATE_EMPTY_LITERAL, EVENT_INTERMEDIATE_MESSAGE_LITERAL, EVENT_INTERMEDIATE_TIMER_LITERAL, EVENT_INTERMEDIATE_ERROR_LITERAL, EVENT_INTERMEDIATE_COMPENSATION_LITERAL, EVENT_INTERMEDIATE_RULE_LITERAL, EVENT_INTERMEDIATE_CANCEL_LITERAL, EVENT_INTERMEDIATE_LINK_LITERAL, EVENT_INTERMEDIATE_MULTIPLE_LITERAL, EVENT_END_EMPTY_LITERAL, EVENT_END_MESSAGE_LITERAL, EVENT_END_ERROR_LITERAL, EVENT_END_COMPENSATION_LITERAL, EVENT_END_TERMINATE_LITERAL, EVENT_END_CANCEL_LITERAL, EVENT_END_LINK_LITERAL, EVENT_END_MULTIPLE_LITERAL};
        VALUES_GATEWAYS_ARRAY = new ActivityType[]{GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL, GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL, GATEWAY_DATA_BASED_INCLUSIVE_LITERAL, GATEWAY_PARALLEL_LITERAL, GATEWAY_COMPLEX_LITERAL};
        VALUES_EVENTS_INTERMEDIATE_ARRAY = new ActivityType[]{EVENT_INTERMEDIATE_EMPTY_LITERAL, EVENT_INTERMEDIATE_MESSAGE_LITERAL, EVENT_INTERMEDIATE_TIMER_LITERAL, EVENT_INTERMEDIATE_ERROR_LITERAL, EVENT_INTERMEDIATE_COMPENSATION_LITERAL, EVENT_INTERMEDIATE_RULE_LITERAL, EVENT_INTERMEDIATE_CANCEL_LITERAL, EVENT_INTERMEDIATE_LINK_LITERAL, EVENT_INTERMEDIATE_MULTIPLE_LITERAL};
        VALUES_EVENTS_START_ARRAY = new ActivityType[]{EVENT_START_EMPTY_LITERAL, EVENT_START_LINK_LITERAL, EVENT_START_MESSAGE_LITERAL, EVENT_START_MULTIPLE_LITERAL, EVENT_START_RULE_LITERAL, EVENT_START_TIMER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
        VALUES_EVENTS = Collections.unmodifiableList(Arrays.asList(VALUES_EVENTS_ARRAY));
        VALUES_EVENTS_INTERMEDIATE = Collections.unmodifiableList(Arrays.asList(VALUES_EVENTS_INTERMEDIATE_ARRAY));
        VALUES_EVENTS_START = Collections.unmodifiableList(Arrays.asList(VALUES_EVENTS_START_ARRAY));
        VALUES_GATEWAYS = Collections.unmodifiableList(Arrays.asList(VALUES_GATEWAYS_ARRAY));
    }

    public static ActivityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return ActivityType.getByName(literal);
    }

    public static ActivityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivityType get(int value) {
        switch (value) {
            case 0: {
                return TASK_LITERAL;
            }
            case 1: {
                return SUB_PROCESS_LITERAL;
            }
            case 2: {
                return EVENT_START_EMPTY_LITERAL;
            }
            case 3: {
                return EVENT_START_MESSAGE_LITERAL;
            }
            case 4: {
                return EVENT_START_RULE_LITERAL;
            }
            case 5: {
                return EVENT_START_TIMER_LITERAL;
            }
            case 6: {
                return EVENT_START_LINK_LITERAL;
            }
            case 7: {
                return EVENT_START_MULTIPLE_LITERAL;
            }
            case 8: {
                return EVENT_INTERMEDIATE_EMPTY_LITERAL;
            }
            case 9: {
                return EVENT_INTERMEDIATE_MESSAGE_LITERAL;
            }
            case 10: {
                return EVENT_INTERMEDIATE_TIMER_LITERAL;
            }
            case 11: {
                return EVENT_INTERMEDIATE_ERROR_LITERAL;
            }
            case 12: {
                return EVENT_INTERMEDIATE_COMPENSATION_LITERAL;
            }
            case 13: {
                return EVENT_INTERMEDIATE_RULE_LITERAL;
            }
            case 14: {
                return EVENT_INTERMEDIATE_LINK_LITERAL;
            }
            case 15: {
                return EVENT_INTERMEDIATE_MULTIPLE_LITERAL;
            }
            case 16: {
                return EVENT_INTERMEDIATE_CANCEL_LITERAL;
            }
            case 17: {
                return EVENT_END_EMPTY_LITERAL;
            }
            case 18: {
                return EVENT_END_MESSAGE_LITERAL;
            }
            case 19: {
                return EVENT_END_ERROR_LITERAL;
            }
            case 20: {
                return EVENT_END_COMPENSATION_LITERAL;
            }
            case 21: {
                return EVENT_END_TERMINATE_LITERAL;
            }
            case 22: {
                return EVENT_END_LINK_LITERAL;
            }
            case 23: {
                return EVENT_END_MULTIPLE_LITERAL;
            }
            case 24: {
                return EVENT_END_CANCEL_LITERAL;
            }
            case 25: {
                return GATEWAY_DATA_BASED_EXCLUSIVE_LITERAL;
            }
            case 26: {
                return GATEWAY_EVENT_BASED_EXCLUSIVE_LITERAL;
            }
            case 27: {
                return GATEWAY_DATA_BASED_INCLUSIVE_LITERAL;
            }
            case 28: {
                return GATEWAY_PARALLEL_LITERAL;
            }
            case 29: {
                return GATEWAY_COMPLEX_LITERAL;
            }
        }
        return null;
    }

    private ActivityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

