/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.SequenceEdgeItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.figures.ConnectionLayerExEx;
import org.eclipse.stp.bpmn.figures.ConnectionUtils;
import org.eclipse.stp.bpmn.figures.SequenceEdgePolylineTargetDecoration;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionEndPointEditPolicyEx;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;

public class SequenceEdgeEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3001;
    private ConnectionRouter rectilinearRouter = null;

    public SequenceEdgeEditPart(View view) {
        super(view);
    }

    protected void refreshVisuals() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refreshVisuals();
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SequenceEdgeItemSemanticEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndPointEditPolicyEx());
    }

    protected Connection createConnectionFigure() {
        return new EdgeFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    this.rectilinearRouter = this.getSource() != null && this.getSource() instanceof Activity2EditPart ? cLayerEx.getBpmnSequenceEdgeForBorderedShapesRectilinearRouter() : cLayerEx.getBpmnSequenceEdgeRectilinearRouter();
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((EdgeFigure)this.getFigure()).routerIsRectilinear = true;
                this.refreshRouterChange();
                return;
            }
        }
        ((EdgeFigure)this.getFigure()).routerIsRectilinear = false;
        super.installRouter();
    }

    protected RotatableDecoration createSourceDecoration() {
        return null;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 && BpmnPackage.eINSTANCE.getSequenceEdge_IsDefault().equals(notification.getFeature())) {
            ((EdgeFigure)this.getFigure()).isDefault = notification.getNewBooleanValue();
            this.getFigure().repaint();
        }
        super.handleNotificationEvent(notification);
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        ConnectionAnchor ca = super.getSourceConnectionAnchor();
        this.updateConnectionAnchor(ca, true);
        return ca;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        ConnectionAnchor ca = super.getTargetConnectionAnchor();
        this.updateConnectionAnchor(ca, false);
        return ca;
    }

    private void updateConnectionAnchor(ConnectionAnchor ca, boolean isSource) {
        if (ca instanceof IModelAwareAnchor) {
            EList seqs;
            IModelAwareAnchor modelAware = (IModelAwareAnchor)ca;
            if (super.getSource() == null) {
                return;
            }
            EList eList = seqs = isSource ? ((Activity)((GraphicalEditPart)super.getSource()).getPrimaryView().getElement()).getOutgoingEdges() : ((Activity)((GraphicalEditPart)super.getTarget()).getPrimaryView().getElement()).getIncomingEdges();
            if (!(this.getPrimaryView().getElement() instanceof SequenceEdge)) {
                String connectionType = isSource && super.getSource() instanceof Activity2EditPart ? String.valueOf(String.valueOf(3001)) + "-subprocessBorder" : String.valueOf(3001);
                modelAware.setConnectionType(isSource, connectionType, 0, 1);
            } else {
                SequenceEdge seqEdge = (SequenceEdge)this.getPrimaryView().getElement();
                int ind = seqs.indexOf((Object)seqEdge);
                int count = seqs.size();
                String connectionType = isSource && super.getSource() instanceof Activity2EditPart ? String.valueOf(String.valueOf(3001)) + "-subprocessBorder" : String.valueOf(3001);
                modelAware.setConnectionType(isSource, connectionType, ind, count);
            }
        }
    }

    public boolean isConditional() {
        ActivityType type;
        Vertex src;
        EObject object = this.getNotationView().getElement();
        return object instanceof SequenceEdge && (src = ((SequenceEdge)object).getSource()) != null && src instanceof Activity && ((type = ((Activity)src).getActivityType()).getValue() == 27 || type.getValue() == 25);
    }

    public class EdgeFigure
    extends PolylineConnectionEx {
        private boolean isDefault;
        private PointList smoothPoints;
        private boolean routerIsRectilinear = false;

        public EdgeFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setTargetDecoration((RotatableDecoration)this.createTargetDecoration());
            RotatableDecoration srcDecoration = SequenceEdgeEditPart.this.createSourceDecoration();
            if (srcDecoration != null) {
                this.setSourceDecoration(srcDecoration);
            }
            this.isDefault = SequenceEdgeEditPart.this.getEdge().getElement() instanceof SequenceEdge ? ((SequenceEdge)SequenceEdgeEditPart.this.getEdge().getElement()).isIsDefault() : false;
        }

        private SequenceEdgePolylineTargetDecoration createTargetDecoration() {
            SequenceEdgePolylineTargetDecoration df = new SequenceEdgePolylineTargetDecoration();
            return df;
        }

        public PointList getSmoothPoints() {
            this.smoothPoints = !this.routerIsRectilinear ? super.getSmoothPoints() : ConnectionUtils.getRoundedRectilinearSmoothPoints(true, this.getPoints(), super.getSmoothness());
            return this.smoothPoints;
        }

        protected void outlineShape(Graphics g) {
            super.outlineShape(g);
            if (this.isDefault) {
                Point res = new Point();
                PointList points = this.smoothPoints;
                int DISTANCE = MapModeUtil.getMapMode((IFigure)this).LPtoDP(40);
                long length = PointListUtilities.getPointsLength((PointList)points);
                long distance = length < (long)(DISTANCE * 2) ? length / 2L : (long)DISTANCE;
                res = PointListUtilities.pointOn((PointList)points, (long)distance, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)res);
                LineSeg segment = PointListUtilities.getNearestSegment((List)PointListUtilities.getLineSegments((PointList)points), (int)res.x, (int)res.y);
                double[] equation = segment.getEquation();
                double a = equation[0];
                double b = equation[1];
                double k = -a / b;
                double angleRad = Math.atan(k);
                double angleDeg = Math.toDegrees(angleRad);
                double angle1 = Math.toRadians(110.0 - angleDeg);
                double angle2 = angle1 + Math.PI;
                double x1 = (double)res.x + 7.0 * Math.cos(angle1);
                double y1 = (double)res.y - 7.0 * Math.sin(angle1);
                double x2 = (double)res.x + 7.0 * Math.cos(angle2);
                double y2 = (double)res.y - 7.0 * Math.sin(angle2);
                PrecisionPoint p1 = new PrecisionPoint(x1, y1);
                PrecisionPoint p2 = new PrecisionPoint(x2, y2);
                g.drawLine((Point)p1, (Point)p2);
            }
        }
    }
}

