/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import java.lang.reflect.Field;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;

public class WrapLabelWithToolTip
extends WrapLabel {
    private static Field textField;
    private final IToolTipProvider _toolTipProvider;
    private String _lastToolTip;
    private boolean trunc = false;

    private static void init() {
        if (textField != null) {
            return;
        }
        try {
            textField = WrapLabel.class.getDeclaredField("text");
            textField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public WrapLabelWithToolTip(IToolTipProvider toolTipProvider) {
        WrapLabelWithToolTip.init();
        this._toolTipProvider = toolTipProvider;
    }

    public WrapLabelWithToolTip(IToolTipProvider toolTipProvider, Dimension prefSize, Dimension minSize, boolean isWrap, int textAlignment) {
        this(toolTipProvider);
        this.prefSize = prefSize;
        this.minSize = minSize;
        this.setFlag(MAX_FLAG << 5, true);
        this.setFlag(MAX_FLAG << 6, true);
    }

    public void setText(String s) {
        if (this.getFont() == null) {
            try {
                textField.set((Object)this, s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.setText(s);
        }
    }

    public void setTextWrap(boolean b) {
        if (this.getFont() != null) {
            super.setTextWrap(b);
        } else {
            this.setFlag(MAX_FLAG << 5, b);
        }
    }

    public void setTextAlignment(int align) {
        if (this.getFont() != null) {
            super.setTextAlignment(align);
        } else {
            this.setAlignmentFlags(align, MAX_FLAG << 6);
        }
    }

    private void setAlignmentFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 2: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
            case 32: {
                this.flags |= 5 * flagOffset;
            }
        }
    }

    public void setTextPlacement(int where) {
        if (this.getFont() != null) {
            this.setTextPlacement(where);
        } else {
            this.setPlacementFlags(where, MAX_FLAG << 18);
        }
        super.setTextPlacement(where);
    }

    private void setPlacementFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 16: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
            }
        }
    }

    public void setTextStrikeThrough(boolean b) {
        if (this.getFont() != null) {
            super.setTextStrikeThrough(b);
        } else {
            this.setFlag(MAX_FLAG << 4, b);
        }
    }

    public void setTextUnderline(boolean b) {
        if (this.getFont() != null) {
            super.setTextUnderline(b);
        } else {
            this.setFlag(MAX_FLAG << 3, b);
        }
    }

    public void setTextWrapAlignment(int i) {
        if (this.getFont() != null) {
            super.setTextWrapAlignment(i);
        } else {
            this.setAlignmentFlags(i, MAX_FLAG << 9);
        }
    }

    private void updateToolTip(String sub) {
        this.trunc = sub != null && sub.length() > 0 && !sub.equals(this.getText());
        String newToolTip = this._toolTipProvider.getToolTipText(this.trunc);
        if (newToolTip == null) {
            if (this._lastToolTip != null) {
                this._lastToolTip = null;
                this.setToolTip(ActivityPainter.createToolTipFigure(this._lastToolTip));
            }
        } else if (!newToolTip.equals(this._lastToolTip)) {
            this._lastToolTip = newToolTip;
            this.setToolTip(ActivityPainter.createToolTipFigure(this._lastToolTip));
        }
    }

    public String getSubStringText() {
        String sub = super.getSubStringText();
        if (this._toolTipProvider != null) {
            this.updateToolTip(sub);
        }
        return sub;
    }

    public void invalidate() {
        if (this.getFont() == null) {
            return;
        }
        Dimension theprefSize = this.getPreferredSize();
        Dimension theminSize = this.getMinimumSize();
        super.invalidate();
        this.minSize = theminSize;
        this.prefSize = theprefSize;
    }

    public int getTextSizeWidth(int w, int h) {
        return super.getTextSize((int)w, (int)h).width;
    }

    public static interface IToolTipProvider {
        public String getToolTipText(boolean var1);
    }
}

