/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.layouts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.figures.SubProcessBodyFigure;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;

public class SubProcessLayout
implements LayoutManager {
    public static final int NAME = 0;
    public static final int BODY = 1;
    public static final int BORDER = 2;
    private IFigure name;
    private SubProcessBodyFigure body;
    private SubProcessBorderFigure border;

    public Object getConstraint(IFigure figure) {
        return null;
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.getPreferredSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return container.getMinimumSize();
    }

    public void invalidate() {
    }

    public void layout(IFigure container) {
        int maxWidth;
        if (((SubProcessEditPart.SubProcessFigure)container).isCollapsed()) {
            Dimension minSize = container.getMinimumSize();
            Dimension borderPrefSize = this.border.getMinimumSize();
            Dimension namePrefSize = this.name.getPreferredSize();
            Rectangle area = container.getClientArea();
            this.name.setLocation(area.getLocation().getCopy());
            this.name.setSize(minSize.width, namePrefSize.height);
            this.body.setLocation(new Point(area.x, area.y + namePrefSize.height));
            this.body.setSize(0, 0);
            this.border.setLocation(new Point(area.x, area.y + minSize.height - borderPrefSize.height));
            this.border.setSize(minSize.width, borderPrefSize.height);
            container.setSize(minSize);
            container.getParent().setSize(container.getSize());
            return;
        }
        Rectangle area = container.getClientArea();
        Dimension selfSize = area.getSize().getCopy();
        Dimension borderPrefSize = this.border.getMinimumSize();
        Dimension namePrefSize = this.name.getPreferredSize();
        Dimension bodyPrefSize = this.body.getSize().getCopy();
        Dimension bodyMinSize = this.body.getMinimumSize().getCopy();
        if (bodyPrefSize.height < bodyMinSize.height) {
            bodyPrefSize.height = bodyMinSize.height;
        }
        if (bodyPrefSize.width < bodyMinSize.width) {
            bodyPrefSize.width = bodyMinSize.width;
        }
        borderPrefSize.width = maxWidth = Math.max(selfSize.width, borderPrefSize.width);
        namePrefSize.width = maxWidth;
        bodyPrefSize.width = maxWidth;
        selfSize.width = maxWidth;
        if (selfSize.height < container.getMinimumSize().height) {
            selfSize.height = container.getMinimumSize().height;
        }
        if (this.body.getSize().height + this.name.getSize().height + this.border.getSize().height > container.getSize().height) {
            selfSize.height = this.body.getSize().height + this.name.getSize().height + this.border.getSize().height;
        } else {
            bodyPrefSize.height = selfSize.height - borderPrefSize.height - namePrefSize.height;
            int bodyPrefSizeMin = container.getMinimumSize().height - borderPrefSize.height - namePrefSize.height;
            if (bodyPrefSize.height < bodyPrefSizeMin) {
                bodyPrefSize.height = bodyPrefSizeMin;
            }
        }
        this.name.setLocation(new Point(area.x, area.y));
        this.name.setSize(namePrefSize);
        this.body.setLocation(new Point(area.x, area.y + namePrefSize.height));
        this.body.setSize(bodyPrefSize);
        this.border.setLocation(new Point(area.x, this.body.getLocation().y + this.body.getSize().height));
        this.border.setSize(borderPrefSize);
        container.setSize(new Dimension(maxWidth, borderPrefSize.height + namePrefSize.height + bodyPrefSize.height));
        container.getParent().setSize(container.getSize());
    }

    public void remove(IFigure figure) {
        if (this.body == figure) {
            this.body = null;
        } else if (this.border == figure) {
            this.border = null;
        } else if (this.name == figure) {
            this.name = null;
        }
    }

    public void setConstraint(IFigure figure, Object constraint) {
        this.remove(figure);
        switch ((Integer)constraint) {
            case 1: {
                this.body = (SubProcessBodyFigure)figure;
                break;
            }
            case 2: {
                this.border = (SubProcessBorderFigure)figure;
                break;
            }
            case 0: {
                this.name = figure;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid constraint");
            }
        }
    }
}

