/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class StartingPointPageContents
extends AbstractStartingPointPageContents {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointPageContents.class);
    private IProject project;
    private String runtimeType;
    private String runtimeID;

    public StartingPointPageContents(IProject project) {
        this.project = project;
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.disable((Control)this.tabFolder);
        this.btnBrowse.removeSelectionListener(this.selectionListener);
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICompilationUnit result;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput((Object)JavaCore.create((IProject)StartingPointPageContents.this.project));
                dialog.setAllowMultiple(false);
                Class[] acceptedClasses = null;
                acceptedClasses = new Class[]{IPackageFragment.class, ICompilationUnit.class};
                MyTypedViewerFilter filter = new MyTypedViewerFilter(StartingPointPageContents.this, acceptedClasses){

                    public boolean select(Viewer viewer, Object parent, Object element) {
                        if (element instanceof IPackageFragmentRoot) {
                            try {
                                return ((IPackageFragmentRoot)element).getKind() == 1;
                            }
                            catch (JavaModelException e) {
                                LOG.error((Object)e);
                                return false;
                            }
                        }
                        return super.select(viewer, parent, element);
                    }
                };
                dialog.addFilter((ViewerFilter)filter);
                if (dialog.open() == 0 && (result = (ICompilationUnit)dialog.getFirstResult()) != null) {
                    try {
                        StartingPointPageContents.this.txtStartingPoint.setText(result.getUnderlyingResource().getLocation().toOSString());
                    }
                    catch (JavaModelException ex) {
                        LOG.error((Object)ex);
                    }
                }
            }
        };
        this.btnBrowse.addSelectionListener(this.selectionListener);
        return control;
    }

    private void disable(Control control) {
        if (control != null) {
            Control[] children;
            if (control instanceof Composite && (children = ((Composite)control).getChildren()) != null && children.length > 0) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.disable(child);
                    ++n2;
                }
            }
            control.setEnabled(false);
        }
    }

    public String getDescription() {
        return "Specify the starting point as the web service class.";
    }

    public String getPageName() {
        return "startingPointPage";
    }

    public String getTitle() {
        return "Starting Point";
    }

    public String validateStartingPoint(String startingPoint) {
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        IStartingPointPageContents runtimePageContents = runtimeMgr.getStartingPointPage(this.runtimeType);
        return runtimePageContents.validateStartingPoint(startingPoint);
    }

    public void setRuntimeInfo(String runtimeType, String runtimeID) {
        this.runtimeID = runtimeID;
        this.runtimeType = runtimeType;
    }

    public boolean getNeedAddWebMethodAnnotations() {
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        IStartingPointPageContents runtimePageContents = runtimeMgr.getStartingPointPage(this.runtimeType);
        return runtimePageContents.getNeedAddWebMethodAnnotations();
    }

    private class MyTypedViewerFilter
    extends ViewerFilter {
        private Class[] fAcceptedTypes;
        private Object[] fRejectedElements;

        public MyTypedViewerFilter(Class[] acceptedTypes) {
            this(acceptedTypes, null);
        }

        public MyTypedViewerFilter(Class[] acceptedTypes, Object[] rejectedElements) {
            Assert.isNotNull((Object)acceptedTypes);
            this.fAcceptedTypes = acceptedTypes;
            this.fRejectedElements = rejectedElements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int i;
            if (this.fRejectedElements != null) {
                i = 0;
                while (i < this.fRejectedElements.length) {
                    if (element.equals(this.fRejectedElements[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.fAcceptedTypes.length) {
                if (this.fAcceptedTypes[i].isInstance(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

