/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.annotations.filter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.annvalidator.filter.IAnnFileFilter;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.builders.JavaDocumentUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

/**
 * filter class for annotation validator
 * @author jma
 *
 */
public class JaxWsAnnFilter implements IAnnFileFilter {

	private static final LoggingProxy LOG = LoggingProxy
	.getlogger(JaxWsAnnFilter.class);
	
	/* We only validate file with jaxws annotations.
	 * will skip files generated from wsdl2java tool
	 * @see org.eclipse.stp.sc.annvalidator.filter.IAnnFileFilter#needsToValidate(org.eclipse.core.resources.IFile)
	 */
	public boolean needsToValidate(IFile file) {
		try {
			if (file.getFileExtension() == null) {
				return false;
			}
			
			if (!file.getFileExtension().equals("java")) {
				return false;
			}

			//check if the file is created from w2j generator
			if (file.getPersistentProperty(JaxWsWorkspaceManager.WSDL_PROPERTY) != null) {
				//this file is generated from wsdl. pass by
				return false;
			}

			ICompilationUnit unit = JDTUtils.getJavaUnitFromFile(file);
			if (unit == null) {
				return false;
			}
			//we only validate java class with @WebService annotation for now
			IType type = unit.findPrimaryType();
			if (type != null) {
				return JavaDocumentUtils.hasWebServiceAnnotation(file);
			}
		} catch (CoreException e) {
			LOG.debug("error when check for validator filter", e);
		}

		return false;
	}

}
