/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.deploy.wtp;

import java.util.Set;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;



public class RuntimeSelectionDialog extends Dialog {
    IRuntime selectedRuntime;
    private List list = null;
    

    protected RuntimeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ScJaxWsResources.getString(
                "WtpDeploy.Runtimedialog.Selectruntime.Label"));
        newShell.forceFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);
        composite.setLayout(new GridLayout());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
        list = new List(composite, SWT.BORDER);
        list.setLayoutData(new GridData(GridData.FILL_BOTH));
        initRuntimeList();

        return composite;
    }

    @SuppressWarnings("unchecked")
    private void initRuntimeList() {
        Set<IRuntime> runtimes = RuntimeManager.getRuntimes();

        for (IRuntime runtime : runtimes) {
            list.add(runtime.getName());
        }
    }

    protected Point getInitialSize() {
        return new Point(300, 200);
    }

    @SuppressWarnings("unchecked")
    protected void okPressed() {
        if ((list.getSelectionCount() != 1) && (list.getItemCount() > 0)) {
            MessageDialog.openError(getShell(), "",
                ScJaxWsResources.getString(
                    "WtpDeploy.Runtimedialog.Selectruntime.Msg"));

            return;
        }

        String selectedRuntimeName = list.getItem(list.getSelectionIndex());
        Set<IRuntime> runtimes = RuntimeManager.getRuntimes();

        for (IRuntime runtime : runtimes) {
            if (runtime.getName().equals(selectedRuntimeName)) {
                selectedRuntime = runtime;
            }
        }

        super.okPressed();
    }

    @SuppressWarnings("unchecked")
    public IRuntime getSelectedRuntime() {
        return selectedRuntime;
    }
}
