/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.deploy.wtp;

import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;

public final class WtpUtils {
    
    private static final String SEPARATOR = "/";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WtpUtils.class);
    private static final String PORT_NAME_HTTP = "HTTP";    
    
    private WtpUtils() {
    }
    
    @SuppressWarnings("unchecked")
    public static String getServerUrl(IFile wsdlFile) throws CoreException {
        IProject project = wsdlFile.getProject();
        String urlPattern = SEPARATOR + project.getName();
        urlPattern += SEPARATOR + "celtix" + SEPARATOR;
        urlPattern += wsdlFile.getName().substring(0, 
            wsdlFile.getName().lastIndexOf("."));
        
        IRuntime runtime = null; 
        Set<IFacetedProject> projects = ProjectFacetsManager.getFacetedProjects();
        for (IFacetedProject fProject : projects) {
            if (fProject.getProject().getName().equals(project.getName())) {
                runtime = fProject.getPrimaryRuntime();
                break;
            }
        }
        
        if (runtime == null) {
            LOG.debug("no primary runtime for this project, return null url");
            return null;
        }
        
        
        IServer[] servers = ServerCore.getServers();
        for (IServer server : servers) {
            if (server.getRuntime().getName().equals(runtime.getName())) {
                String url = "http://" + server.getHost();
                ServerPort[] ports = server.getServerPorts(null);
                for (ServerPort port : ports) {
                    if (port.getName().equals(PORT_NAME_HTTP)) {
                        url += ":" + Integer.toString(port.getPort());
                        url += urlPattern;
                        LOG.debug("server url:" + url);
                        return url;        
                    }
                }
            }
        }    
        return null;    
    }
}
