/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPropertyPageContents;
import org.eclipse.stp.sc.jaxws.workspace.ScJavaFirstNature;
import org.eclipse.stp.sc.jaxws.workspace.ScWsdlFirstNature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DefaultProjectPropertiesPageContents implements
		IPropertyPageContents {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(DefaultProjectPropertiesPageContents.class);

	protected IProject project;
	
	public Control createContents(Composite parent) {
		Group grpRuntime = new Group(parent, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        grpRuntime.setLayout(gridLayout);
        GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpRuntime.setLayoutData(gridData);
	    
        Label runtimeLbl = new Label(grpRuntime, SWT.NONE);
        runtimeLbl.setText(ScJaxWsResources.getString("project.propertypage.runtime"));
        
        //get the runtime info
        String runtimeId = RuntimeCore.getRuntimeID(project);
        Text runtimeTxt = new Text(grpRuntime, SWT.SINGLE | SWT.BORDER);
        runtimeTxt.setText(runtimeId);
        runtimeTxt.setEditable(false);
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        runtimeTxt.setLayoutData(gridData);

        Label lblProgramMode = new Label(grpRuntime, SWT.NONE);
        lblProgramMode.setText(ScJaxWsResources.getString("project.propertypage.programmindmode"));
        Text txtProgramMode = new Text(grpRuntime, SWT.SINGLE | SWT.BORDER);
        try{
            if(project.hasNature(ScJavaFirstNature.NATURE_ID)){
            	txtProgramMode.setText("Java First");
            }else if(project.hasNature(ScWsdlFirstNature.NATURE_ID)){
            	txtProgramMode.setText("Wsdl First");
            }
        }catch(CoreException ex){
        	LOG.error(ex);
        }
        txtProgramMode.setEditable(false);
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        txtProgramMode.setLayoutData(gridData);

        
		return parent;
	}

	public String getErrorMsg() {
		return null;
	}

	public boolean isPageValid() {
		return true;
	}

	public void performDefault() {
		//do nothing
	}

	public void performOK() {
		//do nothing
	}

	public void setChangeListener(IPageContentsChangeListener listener) {
		//do nothing
	}
	
	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}
	
	public void setProject(IProject project){
		this.project = project;
	}
	
	public IProject getProject(){
		return this.project;
	}

}
