/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import java.util.ArrayList;

import javax.jws.WebService;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webservice.CreateWebServiceWizard;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Composite;

/**
 * @author qhuang
 *
 */
public class StartingPointWizardPage extends WizardPageBase<IStartingPointPageContents> {


	/**
	 * the current runtime type that this page is generated
	 * is it is changed. we need to redraw the control
	 */

	private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointWizardPage.class);
    private IWizardPage nextPage = null;
    
	public StartingPointWizardPage(String pageName) {
    	super(pageName, null);
    }

    protected Composite createPage(Composite parent) {
    	pageContents.createContents(parent);
    	return parent;
    }
    
    public void updateControl(String newRuntimeType) {
    	RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
    	pageContents = rtMgr.getStartingPointPage(newRuntimeType);
    	if(pageContents != null){
    		pageContents.setChangeListener(this);
    		super.updateControl();
    	}
    	
    	//update additional wizard pages
    	IAdditionalPageContents addPage = rtMgr.getAdditionalPage(newRuntimeType);
    	if(addPage != null){
    		AdditionalWizardPage newWizardPage = new AdditionalWizardPage(addPage.getPageName(), addPage);
    		newWizardPage.setWizard(getWizard());
    		nextPage = newWizardPage;
    		
    	}else{
    		nextPage = null;
    	}
    }
    
    public IWizardPage getNextPage(){
    	return nextPage;
    }
    
    public void setNextPage(IWizardPage page){
    	this.nextPage = page;
    }
    
    public void performFinish(IProject project){
    	super.performFinish(project);
    	
    	try{
    		//import starting point file
    		String originalFile = pageContents.getStartingPoint();
    		IFile targetFile = JDTUtils.importJavaFileToProject(originalFile, JaxWsWorkspaceManager.getSrcFolder(project));
    		project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, targetFile.getProjectRelativePath().toOSString());
    		
    		importDependencies(project);
    		
    		addExternalLibraries(project);
    		
    		project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);

    		annotateStartPointClass(project);
    		
            //select and open this java file 
            ResourceUtils.selectAndOpenResource(targetFile);


    	}catch(Exception ex){
    		LOG.error("error during import the starting point", ex);
    	}
    }
    
    protected void annotateStartPointClass(IProject project){
    	ICompilationUnit cu = null;
    	try{
    		String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
    		IFile targetFile = project.getFile(fileName);
    		cu = ((ICompilationUnit)JavaCore.create(targetFile));
    		cu.open(null);
    		
    		IType mainType = cu.findPrimaryType();
    		
    		if(mainType.isInterface()){
    			annotateInterface(mainType);
    		}else{
    			if(mainType.getSuperInterfaceNames() != null && mainType.getSuperInterfaceNames().length > 0){
    				annotateImpl(mainType);
    			}else{
    				annotatePojo(mainType);
    			}
        	}
    	}catch (Exception ex){
    		LOG.error("error while add web service annotations to the starting point of project: " + project);
    	}finally{
    		try{
        		if(cu != null && cu.isOpen()){
        			cu.save(null, true);
        			cu.close();
        		}
    		}catch(Exception ex){
    			LOG.error(ex);
    		}
    	}
    	
    }
    
    protected void addExternalLibraries(IProject project){
    	String[] libs = pageContents.getDependentLibraries();
    	if(libs != null && libs.length > 0){
    		ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
    		for(int i = 0; i < libs.length; i++){
    			try{
    				clsLibs.add(JavaCore.newLibraryEntry(new Path(libs[i]), null, null));
    			}catch(Exception ex){
    				LOG.error("error during creating librarie: " + libs[i], ex);
    			}
    		}
    		try{
        		if(clsLibs.size() > 0){
        			WorkspaceManager.addEntriesToClassPath(JavaCore.create(project), clsLibs);
        		}
    		}catch(Exception ex){
				LOG.error("error during adding libraries: " + clsLibs, ex);
			}
    	}
    }
    
    protected void importDependencies(IProject project){
    	String[] files = pageContents.getDependentJavaFiles();
    	if(files != null && files.length > 0){
    		for(int i = 0; i < files.length; i++){
    			try{
    				JDTUtils.importJavaFileToProject(files[i], JaxWsWorkspaceManager.getSrcFolder(project));
    			}catch(Exception ex){
    				LOG.error("error during import java file: " + files[i], ex);
    			}
    		}
    	}
    }
    
    private void annotateInterface(IType mainType){
    	IPreferenceStore store = null;
    	IWizard wizard = null;
    	try{
        	store = ScJaxWsPlugin.getDefault().getPreferenceStore();
        	String prefValue = store.getString(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED);
        	store.setValue(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED, SCPreferenceConstants.VAL_ANN_WIZ_DISABLED);
        	
        	if(mainType.isInterface()){
            	//add web service annotation to the main type
            	wizard = new CreateWebServiceWizard(mainType);
                wizard.performFinish();
                store.setValue(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED, prefValue);
                
                //add web method annotations to method
                if(pageContents.getNeedAddWebMethodAnnotations()){
                    IMethod[] methods = mainType.getMethods();
                    if(methods != null && methods.length > 0){
                    	if(mainType.isInterface()){
                        	for(int i = 0; i < methods.length; i++){
                                wizard = new CreateWebMethodWizard(methods[i]);
                                wizard.performFinish();
                        	}
                    	}else if(!Flags.isAbstract(mainType.getFlags())){
                        	for(int i = 0; i < methods.length; i++){
                                if(Flags.isPublic(methods[i].getFlags()) &&
                                		!Flags.isAbstract(methods[i].getFlags())){
                            		wizard = new CreateWebMethodWizard(methods[i]);
                                    wizard.performFinish();
                                }
                        	}
                    	}else{
                    		LOG.error("invalid class to be annotated: " + mainType.getElementName());
                    	}
                    }
                }
        	}else{
        		LOG.error("this class is not an interface: " + mainType.getElementName());
        	}

    	}catch (Exception ex){
    		LOG.error("error while add web service annotations to the SEI class: " + mainType);
    	}

    }
    
    private void annotateImpl(IType mainType){
    	try{
        	if(mainType.isInterface()){
        		LOG.error("this class should not be an interface: " + mainType.getElementName());
        		return;
        	}
    		String[] superInterfaceNames = mainType.getSuperInterfaceNames();
    		if(superInterfaceNames != null && superInterfaceNames.length > 0){
    			//if has super interface

    			//annotate the sei
    			IType[] interfaces = mainType.newSupertypeHierarchy(null).getAllInterfaces();
    			
    			if(interfaces == null){
    				annotatePojo(mainType);
    				return;
    			}
    			IType webserviceType = interfaces[0]; //TODO maybe need check if any interface already has web service annotation
    			ICompilationUnit cu = webserviceType.getCompilationUnit();
    			if(cu.exists()){
    				cu.open(null);
    				annotateInterface(webserviceType);
    				cu.save(null, true);
    				cu.close();
    			}
    			
    			
    			//annotate the impl
				CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(mainType);
				ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
		        MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "endpointInterface", webserviceType.getFullyQualifiedName());
		        annotValues.add(valPair);
				Annotation node = JDTUtils.newNormalAnnotation(
						astRoot, 
						WebService.class.getSimpleName(), 
						annotValues);
				if(node != null){
					try{
						ScJDTUtils.addAnnotationToCu(mainType.getCompilationUnit(), astRoot, node, mainType, null, true);
					}catch(Exception e){
						LOG.error(e.getMessage(), e);
					}
					
				}
    			
    		}else{
    			LOG.error("this class should be an IMPL class: " + mainType);
    		}   
    	}catch(Exception ex){
    		LOG.error("error while add web service annotations to the IMPL class: " + mainType);
    	}
    }
    
    private void annotatePojo(IType mainType){
		try{
			CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(mainType);
			Annotation node = JDTUtils.newNormalAnnotation(
					astRoot, 
					WebService.class.getSimpleName(), 
					null);
			if(node != null){
				try{
					ScJDTUtils.addAnnotationToCu(mainType.getCompilationUnit(), astRoot, node, mainType, null, true);
				}catch(Exception e){
					LOG.error(e.getMessage(), e);
				}
				
			}
		}catch(Exception ex){
			LOG.error("error while add web service annotations to the POJO class: " + mainType);
		}
    }

}
