/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class StartingPointPageContents extends
		AbstractStartingPointPageContents {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointPageContents.class);
	
	private IProject project;
	private String runtimeType;
	private String runtimeID;
	
	public StartingPointPageContents(IProject project){
		this.project = project;
	}
	
	public Control createContents(Composite parent){
		Control control = super.createContents(parent);
		disable(this.tabFolder);
		this.btnBrowse.removeSelectionListener(selectionListener);
		this.btnBrowse.addSelectionListener(selectionListener = new SelectionAdapter(){
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ElementTreeSelectionDialog dialog = 
					new ElementTreeSelectionDialog(
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
						new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 
						new StandardJavaElementContentProvider()); 
				dialog.setInput(JavaCore.create(project));//ResourcesPlugin.getWorkspace().getRoot()));
				dialog.setAllowMultiple(false);
				Class[] acceptedClasses = null;
				acceptedClasses = new Class[] {IPackageFragment.class, ICompilationUnit.class };
				ViewerFilter filter = new MyTypedViewerFilter(acceptedClasses) {
					public boolean select(Viewer viewer, Object parent, Object element) {
						if (element instanceof IPackageFragmentRoot) {
							try {
								return (((IPackageFragmentRoot)element).getKind() == IPackageFragmentRoot.K_SOURCE);
							} catch (JavaModelException e) {
								LOG.error(e); // just log, no ui in validation
								return false;
							}
						}
						return super.select(viewer, parent, element);
					}
				};	
				dialog.addFilter(filter);
				if(ElementTreeSelectionDialog.OK == dialog.open()){
					ICompilationUnit result = (ICompilationUnit)dialog.getFirstResult();
					if(result != null){
						try{
							txtStartingPoint.setText(result.getUnderlyingResource().getLocation().toOSString());
						}catch(JavaModelException ex){
							LOG.error(ex); 
						}
					}
				}
			}
		});		
		return control;
	}
	
	private void disable(Control control){
		if(control != null){
			if(control instanceof Composite){
				Control[] children = ((Composite)control).getChildren();
				if(children != null && children.length > 0){
					for(Control child:children){
						disable(child);
					}
				}
			}
			control.setEnabled(false);
		}
	}
	
	public String getDescription() {
		return "Specify the starting point as the web service class.";
	}

	public String getPageName() {
		return JavaFirstEnableWizard.STARTING_POINT_PAGE_NAME;
	}

	public String getTitle() {
		return "Starting Point";
	}
	
	/**
	 * Viewer filter used in selection dialogs.
	 */
	private class MyTypedViewerFilter extends ViewerFilter {

		private Class[] fAcceptedTypes;
		private Object[] fRejectedElements;

		/**
		 * Creates a filter that only allows elements of gives types.
		 * @param acceptedTypes The types of accepted elements
		 */
		public MyTypedViewerFilter(Class[] acceptedTypes) {
			this(acceptedTypes, null);
		}

		/**
		 * Creates a filter that only allows elements of gives types, but not from a
		 * list of rejected elements.
		 * @param acceptedTypes Accepted elements must be of this types
		 * @param rejectedElements Element equals to the rejected elements are
		 * filtered out
		 */	
		public MyTypedViewerFilter(Class[] acceptedTypes, Object[] rejectedElements) {
			Assert.isNotNull(acceptedTypes);
			fAcceptedTypes= acceptedTypes;
			fRejectedElements= rejectedElements;
		}	

		/**
		 * @see ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public boolean select(Viewer viewer, Object parentElement, Object element) {
			if (fRejectedElements != null) {
				for (int i= 0; i < fRejectedElements.length; i++) {
					if (element.equals(fRejectedElements[i])) {
						return false;
					}
				}
			}
			for (int i= 0; i < fAcceptedTypes.length; i++) {
				if (fAcceptedTypes[i].isInstance(element)) {
					return true;
				}
			}
			return false;
		}
	}
	
	public String validateStartingPoint(String startingPoint){
		RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
		IStartingPointPageContents runtimePageContents = runtimeMgr.getStartingPointPage(runtimeType);
		return runtimePageContents.validateStartingPoint(startingPoint);
	}
	
	public void setRuntimeInfo(String runtimeType, String runtimeID){
		this.runtimeID = runtimeID;
		this.runtimeType = runtimeType;
	}
	
	public boolean getNeedAddWebMethodAnnotations(){
		RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
		IStartingPointPageContents runtimePageContents = runtimeMgr.getStartingPointPage(runtimeType);
		return runtimePageContents.getNeedAddWebMethodAnnotations();
	}
	
	
	
	
	

}
