/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.sc.cxf.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class Java2wsActionBase implements
		IWorkbenchWindowActionDelegate {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(Java2wsActionBase.class);

	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub

	}

	public void run(IAction action) {
		try{

			ProgressMonitorDialog pmd = new ProgressMonitorDialog( PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
	    	IRunnableWithProgress rwp = new IRunnableWithProgress() {
	            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
	            	invokeGenerator();
	            }
	    	};
	        pmd.run(false, false, rwp); 
		} catch (Exception e) {
		      LOG.error("error during webservice artifacts generation", e);
		}

	}

	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}
	
	private void invokeGenerator(){
		try{


			IProject project = ResourceUtils.getActiveProject();
			project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
			CxfJava2wsGenerator generator = CxfJava2wsGenerator.getInstance();
			
			//remember current property
			String genServer = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER);
			String genClient = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT);
			String genWsdl = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL);

			
			setGeneratorParameters(project);
			
			//generate
           	generator.run(project);
           	
			//roll back to the original values
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, genWsdl);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, genServer);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, genClient);
			
           	project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);

			project.refreshLocal(IResource.DEPTH_INFINITE, null);
		} catch (Exception e) {
		      LOG.error("error during webservice artifacts generation", e);
		}

	}
	
	public abstract void setGeneratorParameters(IProject project) throws CoreException; 
}
