package org.eclipse.stp.sc.common.internal.viewers;

import java.util.HashSet;

import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTableLabelProvider;

public class StpRuntimeTableLabelProvider extends RuntimeTableLabelProvider {

	public String getColumnText(Object element, int columnIndex) {
		//show the technologies type
		
		if (columnIndex == 2) {
			IRuntime runtime = (IRuntime) element;
			String tech = "";
			IModuleType[] types = runtime.getRuntimeType().getModuleTypes();
			HashSet set = new HashSet();
			for (IModuleType type : types) {
				if (set.contains(type.getName())) {
					continue;
				}
				set.add(type.getName());
				tech += type.getName();
				tech += " ";
			}
			
			return tech;
		}
		return super.getColumnText(element, columnIndex);
	}
}
