/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder.inst;

/**
 * @author jma
 * mapping all Load and Store instructions
 */
public interface JLSInst {
    public final static short ILOAD = 0x15;
    public final static short ILOAD_N = 0x1a;
    public final static short LLOAD = 0x16;
    public final static short LLOAD_N = 0x1e;
    public final static short FLOAD = 0x17;
    public final static short FLOAD_N = 0x22;
    public final static short DLOAD = 0x18;
    public final static short DLOAD_ = 0x26;
    public final static short ALOAD = 0x19;
    public final static short ALOAD_ = 0x2a;
    public final static short BIPUSH = 0x10;
    public final static short SIPUSH = 0x11;
    public final static short LDC = 0x12;
    public final static short LDC_W = 0x13;
    public final static short LDC2_W = 0x14;
    //todo support iconst_<i>
    //public final static short ICONST = ;
    //public final static short LCONST ;
    public final static short LCONST_ = 0x9;
    public final static short FCONST = 0xb;
    //public final static short DCONST;
    public final static short DCONST_ = 0xe;
    //public final static short ICONST_M1;
    public final static short ACONST_NULL = 0x1;
    public final static short ISTORE = 0x36;
    public final static short LSTORE = 0x37;
    public final static short FSTORE = 0x38;
    public final static short DSTORE = 0x39;
    public final static short ASTORE = 0x3a;
    public final static short ASTORE_ = 0x4b;
    public final static short ISTORE_N = 0x3b;
    public final static short LSTORE_N = 0x3f;
    public final static short FSTORE_N = 0x43;
    public final static short DSTORE_N = 0x47;
    //public final static short STRORE_N;
    public final static short WIDE = 0xc4;
    
    public final static short BALOAD = 0x33;
	public final static short CALOAD = 0x34;
	public final static short SALOAD = 0x35;
	public final static short IALOAD = 0x2e;
	public final static short LALOAD = 0x2f;
	public final static short FALOAD = 0x30;
	public final static short DALOAD = 0x31;
	public final static short AALOAD = 0x32;
	public final static short AALOAD_ = 0x4b;
	
	public final static short BASTORE = 0x54;
	public final static short CASTORE = 0x55;
	public final static short SASTORE = 0x56;
	public final static short IASTORE = 0x4f;
	public final static short LASTORE = 0x50;
	public final static short FASTORE = 0x51;
	public final static short DASTORE = 0x52;
	public final static short AASTORE = 0x53;
	
	public final static short ARRAYLENGTH = 0xbe;
}
