/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.model.IModuleFile;

public class ModuleFile
implements IModuleFile {
    protected IFile file;
    protected File file2;
    protected String name;
    protected IPath path;
    protected long stamp = -1L;

    public ModuleFile(IFile file, String name, IPath path) {
        this.file = file;
        this.name = name;
        this.path = path;
        if (file != null) {
            this.stamp = file.getModificationStamp() + file.getLocalTimeStamp();
        }
    }

    public ModuleFile(File file, String name, IPath path) {
        this.file2 = file;
        this.name = name;
        this.path = path;
        if (file != null) {
            this.stamp = this.file2.lastModified();
        }
    }

    public ModuleFile(String name, IPath path, long stamp) {
        this.name = name;
        this.path = path;
        this.stamp = stamp;
    }

    public long getModificationStamp() {
        return this.stamp;
    }

    public IPath getModuleRelativePath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IModuleFile)) {
            return false;
        }
        IModuleFile mf = (IModuleFile)obj;
        if (!this.name.equals(mf.getName())) {
            return false;
        }
        return this.path.equals((Object)mf.getModuleRelativePath());
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.path.hashCode();
    }

    public Object getAdapter(Class cl) {
        if (IFile.class.equals((Object)cl)) {
            return this.file;
        }
        if (File.class.equals((Object)cl)) {
            return this.file2;
        }
        return null;
    }

    public String toString() {
        return "ModuleFile [" + this.name + ", " + this.path + ", " + this.stamp + "]";
    }
}

