/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.cheetsheets;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.ui.actions.ExecuteDeployActionDelegate;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

/**
* The cheat sheet action that
* invokes the new Execute Deployment Package process
*
* @author Jane Cantz
*/
public class DeployPackageAction extends InvokeEditorActions
{
	public DeployPackageAction()
	{
		super();
	}
		
	public void run(String[] params, ICheatSheetManager manager) 
	{
		DeployEditor deployEditor = getDeployEditor();
		if (deployEditor != null) 
		{
			IEditorInput input = deployEditor.getEditorInput();
			if (input instanceof IFileEditorInput) 
			{
				IFile file = ((IFileEditorInput) input).getFile();
				ExecuteDeployActionDelegate action = new  ExecuteDeployActionDelegate();
				action.selectionChanged(null, new StructuredSelection(file));
				IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
				action.setActivePart(null, part);
				action.run(null);
				notifyResult(true);
				return;
			}
		}

		//  Deploy Editor is not open
		notifyResult(reportWrongEditor());
	}
 }
