/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackageConfigurationManager;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on Nov 1, 2004
 */
public class ConfigurablePackageExtension extends ServiceDescriptorExtension
		implements IConfigurablePackageExtension {

	public static final String ATTR_CONFIGURATION_MANAGER = "configurationManager"; //$NON-NLS-1$

	private IPackageConfigurationManager mConfigManager;

	/**
	 * @param element
	 * @throws PackageExtensionException
	 */
	public ConfigurablePackageExtension(IConfigurationElement element)
			throws PackageExtensionException {
		super(element);
		init();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension#getPackageConfigurationManager()
	 */
	public IPackageConfigurationManager getPackageConfigurationManager() {
		if (mConfigManager == null) {
			try {
				mConfigManager = (IPackageConfigurationManager) getConfigurationElement()
						.createExecutableExtension(ATTR_CONFIGURATION_MANAGER);
			}
			catch (CoreException e) {
				if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
					System.err
							.println(DeployCorePlugin
									.getDefault()
									.getResourceString(
											"ConfigurablePackageExtension.trace.error.couldNotLoadPackageConfigurationManager", //$NON-NLS-1$
											new Object[] {
													getID(),
													getConfigurationElement()
															.getAttribute(
																	ATTR_CONFIGURATION_MANAGER)}));
					System.err.flush();
				}
			}
		}
		return mConfigManager;
	}

	private void init() throws PackageExtensionException {
		Assert.isTrue(DeploymentExtensionManager.EXT_ELEM_CONFIGURABLE_PACKAGE
				.equals(getConfigurationElement().getName()));
	}

}