/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.IRuntimeType;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.ISupportedRuntimeType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;
import org.eclipse.stp.soas.deploy.core.Version;


/**
 * @author rcernich
 * 
 * Created on Apr 8, 2004
 */
public class SupportedRuntimeType implements ISupportedRuntimeType {

	public static final String ATTR_TYPE = "type"; //$NON-NLS-1$
	public static final String ATTR_MIN_VERSION = "minVersion"; //$NON-NLS-1$
	public static final String ATTR_MAX_VERSION = "maxVersion"; //$NON-NLS-1$
	public static final String ATTR_MATCH_RULE = "matchRule"; //$NON-NLS-1$

	
	private IConfigurationElement mElement;
	private String mRuntimeDef;
	private IVersion mMinVersion;
	private IVersion mMaxVersion;
	private MatchRule mMatchRule;

	public SupportedRuntimeType(IConfigurationElement element)
			throws PackageExtensionException {
		super();
		init(element);
	}
	
	public SupportedRuntimeType(String runtimeDef, IVersion minVersion,
			IVersion maxVersion, MatchRule matchRule) {
		super();
		this.mRuntimeDef = runtimeDef;
		this.mMinVersion = minVersion;
		this.mMaxVersion = maxVersion;
		this.mMatchRule = matchRule;

	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedServerType#getServerDefinition()
	 */
	public IRuntimeDefinition getRuntimeDefinition() {
		return DeploymentExtensionManager.getInstance().getRuntimeDefinition(
				mRuntimeDef);
		
		/*
		return ServerCore.findRuntimeType(mRuntimeDef);
		*/
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedServerType#getMinVersion()
	 */
	public IVersion getMinVersion() {
		return mMinVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedServerType#getMaxVersion()
	 */
	public IVersion getMaxVersion() {
		return mMaxVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedServerType#getVersionMatchRule()
	 */
	public MatchRule getVersionMatchRule() {
		return mMatchRule;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedServerType#supportsServer(org.eclipse.stp.soas.deploy.core.IServerType)
	 */
	public boolean supportsRuntime(IRuntimeType type) {
		IVersion typeVersion = type.getVersion();
		return type.getRuntimeDefinition().equals(getRuntimeDefinition())
				&& typeVersion.compareTo(getMinVersion()) >= 0
				&& (typeVersion.compareTo(getMaxVersion()) <= 0 || getMaxVersion()
						.isCompatibleWithVersion(typeVersion,
								getVersionMatchRule()));
		/*
		int intVersion = new Integer(type.getVersion()).intValue();
		IVersion typeVersion = new Version(intVersion, intVersion, 0, "");
		return type.equals(getRuntimeDefinition())
				&& typeVersion.compareTo(getMinVersion()) >= 0
				&& (typeVersion.compareTo(getMaxVersion()) <= 0 || getMaxVersion()
						.isCompatibleWithVersion(typeVersion,
								getVersionMatchRule()));
								*/
		
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		if (mMinVersion.equals(mMaxVersion)) {
			buf.append(mMinVersion);
		}
		else {
			buf.append(mMinVersion).append('-').append(mMaxVersion);
		}

		return DeployCorePlugin.getDefault().getResourceString(
				"SupportedServerType.toString", //$NON-NLS-1$
				new Object[] { mRuntimeDef, buf.toString(), mMatchRule});
	}

	private void init(IConfigurationElement element)
			throws PackageExtensionException {
		Assert.isTrue(DeploymentExtensionManager.EXT_ELEM_SUPPORTED_RUNTIME
				.equals(element.getName()));

		if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
			System.out
					.println(DeployCorePlugin
							.getDefault()
							.getResourceString(
									"SupportedServerType.trace.processingSupportedServer", //$NON-NLS-1$
									new Object[] {
											element.getDeclaringExtension()
													.getContributor().getName(),
											((IConfigurationElement) element
													.getParent()).getName()}));
		}

		boolean error = false;

		mElement = element;

		mRuntimeDef = mElement.getAttribute(ATTR_TYPE);
		mMinVersion = Version.valueOf(mElement.getAttribute(ATTR_MIN_VERSION));
		mMaxVersion = Version.valueOf(mElement.getAttribute(ATTR_MAX_VERSION));
		String matchRule = mElement.getAttribute(ATTR_MATCH_RULE);
		if (matchRule == null || MatchRule.valueOf(matchRule.trim()) == null) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.out
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedServerType.trace.warning.matchRuleNotSpecified")); //$NON-NLS-1$
				System.out.flush();
			}
			mMatchRule = MatchRule.EQUIVALENT;
		}
		else {
			mMatchRule = MatchRule.valueOf(matchRule.trim());
		}

		if (mRuntimeDef == null) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedServerType.trace.error.typeNotSpecified")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		//else if (ServerCore.findRuntimeType(mRuntimeDef) == null) {
		else if (DeploymentExtensionManager.getInstance().getRuntimeDefinition(
				mRuntimeDef) == null) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedServerType.trace.error.invalidTypeSpecified")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		if (mMinVersion.compareTo(mMaxVersion) > 0) {
			error = true;
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedServerType.trace.error.minVersionGreaterThanMaxVersion")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		else if (mMaxVersion.compareTo(Version.NULL_VERSION) == 0) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"SupportedServerType.trace.error.versionsNotSet")); //$NON-NLS-1$
				System.err.flush();
			}
		}
		if (error) {
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"SupportedServerType.exception.supportedServerParseError")); //$NON-NLS-1$
		}
	}

}