package org.eclipse.stp.soas.internal.deploy.ui.views;

import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;

/**
 * @author rcernich, shongxum, brianf
 */
public class ServerContentProvider implements ITreeContentProvider {
	
	public static final String REPOSITORY_CATEGORY_ID = "org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"; //$NON-NLS-1$	

	private boolean mShowCategories = true;

	private Viewer mViewer;

	private Object mInput;
	
	private Map<IServerType, List<IServer>> mpServer;
 


	/**
	 * Constructor
	 */
	public ServerContentProvider() {
		super();
		mpServer = DeploymentUtil.getServerMap();
		 
	}
  



	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		Object[] children = new Object[0]; 
		if(parentElement instanceof IServerType 
				&& mpServer.containsKey(parentElement)){			
			return mpServer.get((IServerType)parentElement).toArray();
		}
		return children;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		Object parent = null;

		if (element instanceof IServer) {
			parent = ((IServer) element).getServerType();
			
		}  
		return parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}

	

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		 
	}


	public Object[] getElements(Object inputElement) {
		if(inputElement instanceof Object[])
		{
			return (Object[])inputElement;
		}
 		return null;
	}


	public void dispose() { 
		
	}
}