/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author rcernich
 * 
 * Created on Jan 28, 2004
 */
public class DeployFileDescriptionWizardPage extends WizardPage implements
		ISummaryDataSource {

	public static final String LABEL_NAME;
	public static final String LABEL_DESCRIPTION;

	private static final int DESCRIPTION_CHAR_WIDTH;

	private Text mNameText;
	private Text mDescText;
	private boolean mNameIntialized = false;
	private String mDeployName = new String();
	private String mDeployDescription = new String();

	/**
	 * @param pageName
	 */
	public DeployFileDescriptionWizardPage(String pageName) {
		super(pageName);
	}

	/**
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	public DeployFileDescriptionWizardPage(String pageName, String title,
											ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void init(Root root) {
	}

	/**
	 * @return Returns the deployDescription.
	 */
	public String getDeployDescription() {
		return mDeployDescription;
	}

	/**
	 * @param deployDescription The deployDescription to set.
	 */
	public void setDeployDescription(String deployDescription) {
		mDeployDescription = deployDescription;
	}

	/**
	 * @return Returns the deployName.
	 */
	public String getDeployName() {
		return mDeployName;
	}

	/**
	 * @param deployName The deployName to set.
	 */
	public void setDeployName(String deployName) {
		mDeployName = deployName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout(2, false));
		content.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label label = new Label(content, SWT.NULL);
		label.setText(LABEL_NAME);
		GridData data = new GridData();
		label.setLayoutData(data);

		mNameText = new Text(content, SWT.BORDER);
		data = new GridData(GridData.FILL_HORIZONTAL);
		mNameText.setLayoutData(data);
		mNameText.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				handleNameModify(e);
			}
		});

		label = new Label(content, SWT.NULL);
		label.setText(LABEL_DESCRIPTION);
		data = new GridData();
		data.horizontalSpan = 2;
		label.setLayoutData(data);

		mDescText = new Text(content, SWT.MULTI | SWT.WRAP | SWT.BORDER
				| SWT.V_SCROLL);
		GC gc = new GC(mDescText);
		gc.setFont(mDescText.getFont());
		FontMetrics fontMetrics = gc.getFontMetrics();
		gc.dispose();
		data = new GridData(GridData.FILL_VERTICAL
				| GridData.HORIZONTAL_ALIGN_FILL);
		data.horizontalSpan = 2;
		data.widthHint = Dialog.convertWidthInCharsToPixels(fontMetrics,
				DESCRIPTION_CHAR_WIDTH);
		mDescText.setLayoutData(data);
		mDescText.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				handleDescriptionModify(e);
			}
		});

		initControls();

		setControl(content);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource#getSummaryData()
	 */
	public List getSummaryData() {
		List summaryData = new ArrayList(2);

		summaryData.add(new String[] {
				DeployCorePlugin.getDefault().getResourceString(
						"DeployFileDescriptionWizardPage.summary.name"), //$NON-NLS-1$
				getDeployName()});

		summaryData.add(new String[] {
				DeployCorePlugin.getDefault().getResourceString(
						"DeployFileDescriptionWizardPage.summary.description"), //$NON-NLS-1$
				getDeployDescription()});

		return summaryData;
	}

	private void initControls() {
		mNameText.setText(mDeployName);
		mDescText.setText(mDeployDescription);
		updateControls();

		validate();
	}

	private void handleNameModify(ModifyEvent event) {
		mDeployName = mNameText.getText();
		validate();
	}

	private void handleDescriptionModify(ModifyEvent event) {
		mDeployDescription = mDescText.getText();
		validate();
	}

	private void updateControls() {
	}

	private void validate() {

		setPageComplete(true);
	}

	static {
		LABEL_NAME = DeployCorePlugin.getDefault().getResourceString(
				"LABEL.Name"); //$NON-NLS-1$
		LABEL_DESCRIPTION = DeployCorePlugin.getDefault()
				.getResourceString("LABEL.Description"); //$NON-NLS-1$
		DESCRIPTION_CHAR_WIDTH = 60;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		if (visible && !mNameIntialized) {
			String fileName = ((DeployFileNewWizard) getWizard())
					.getOutputFile().getProjectRelativePath().lastSegment();
			int extPos = fileName.lastIndexOf('.');
			if (extPos > 0) {
				fileName = fileName.substring(0, extPos);
			}
			mNameText.setText(fileName);
			mNameIntialized = true;
		}
		super.setVisible(visible);
	}
}