/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat;

import java.io.OutputStream;
import java.io.PrintStream;


/**
 * deploy descriptor for one endpoint for Celtix servlet configuration
 * @author jma
 *
 */
public class WebDeployDescriptor {
    private String id;    
    private String implClsName;
    private String wsdlPath;
    private String address;

    public WebDeployDescriptor() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id=" + id);
        sb.append("implementor=" + implClsName);
        sb.append("wsdlLocation=" + wsdlPath); 
        sb.append("address=" + address);

        return sb.toString();
    }

    public String getEndpointName() {
        return id;
    }

    public void setEndpointName(String value) {
        this.id = value;
    }

    public String getImplClsName() {
        return implClsName;
    }

    public void setImplClsName(String value) {
        this.implClsName = value;
    }  

    public String getPattern() {
        return address;
    }

    public void setPattern(String value) {
        this.address = value;
    } 
    
    public String getWsdlPath() {
        return wsdlPath;
    }

    public void setWsdlPath(String value) {
        this.wsdlPath = value;
    }

    public void serizlize(OutputStream os) {
        PrintStream ps = new PrintStream(os);
        ps.println("<jaxws:endpoint");
        ps.println("    id=\"" + id + "_xml_bare" + "\"");
        ps.println("    implementor=\"" + implClsName + "\"");
        ps.println("    wsdlLocation=\"" + wsdlPath + "\"");
        ps.println("    address=\"/" + address + "\" >");
        ps.println("       <jaxws:features>");
        ps.println("            <bean class=\"org.apache.cxf.feature.LoggingFeature\"/>");
        ps.println("       </jaxws:features>");
        ps.println("</jaxws:endpoint>");
        ps.flush();
    }
}
