/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions.activitytypes;

import java.net.URL;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.provider.ActivityItemProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeActivityTypeAction
extends AbstractActionHandler {
    public static final String ABSTRACT_ID = "setActivityTypeTo";
    private ActivityType _type;

    public ChangeActivityTypeAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    public ChangeActivityTypeAction(IWorkbenchPage workbenchPage, String name) {
        super(workbenchPage);
        this._type = ActivityType.get((String)name.substring(ABSTRACT_ID.length()));
    }

    public void init() {
        super.init();
        this.setId(ABSTRACT_ID + this.getActivityType().getLiteral());
        this.setText(this.getActivityType().getName());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)((URL)new ActivityItemProvider(null).getImage((Object)this.getActivityType()))));
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection.getFirstElement() instanceof IGraphicalEditPart) {
            final IGraphicalEditPart part = (IGraphicalEditPart)selection.getFirstElement();
            final EObject object = ((IGraphicalEditPart)selection.getFirstElement()).resolveSemanticElement();
            if (object instanceof Activity) {
                CompoundCommand compound = new CompoundCommand();
                if (ActivityType.SUB_PROCESS_LITERAL.equals((Object)this._type)) {
                    compound.add((Command)new ICommandProxy((ICommand)new MyCommand(object){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Activity act = (Activity)object;
                            Node actnode = (Node)part.getNotationView();
                            SubProcess sp = BpmnFactory.eINSTANCE.createSubProcess();
                            sp.setActivityType(ActivityType.SUB_PROCESS_LITERAL);
                            sp.setName(act.getName());
                            sp.setNcname(act.getNcname());
                            sp.setDocumentation(act.getDocumentation());
                            sp.setGraph(act.getGraph());
                            sp.setID(act.getID());
                            sp.setLane(act.getLane());
                            sp.setLooping(act.isLooping());
                            sp.getIncomingEdges().addAll((Collection)act.getIncomingEdges());
                            sp.getOutgoingEdges().addAll((Collection)act.getOutgoingEdges());
                            Node node = ViewService.createNode((View)((View)part.getNotationView().eContainer()), (EObject)sp, (String)BpmnVisualIDRegistry.getType(2002), (PreferencesHint)BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                            node.setLayoutConstraint(actnode.getLayoutConstraint());
                            node.getTargetEdges().addAll((Collection)actnode.getTargetEdges());
                            node.getSourceEdges().addAll((Collection)actnode.getSourceEdges());
                            Command co = part.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest((EObject)act, false)));
                            co.execute();
                            Command autosize = part.getCommand(new Request((Object)"autosize"));
                            autosize.execute();
                            return CommandResult.newOKCommandResult();
                        }
                    }));
                } else {
                    compound.add((Command)new ICommandProxy((ICommand)new MyCommand(object){

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Activity act = (Activity)object;
                            if (ChangeActivityTypeAction.this.getActivityType().getValue() != 0 && ChangeActivityTypeAction.this.getActivityType().getValue() != 1) {
                                act.setLooping(false);
                            }
                            act.setActivityType(ChangeActivityTypeAction.this.getActivityType());
                            part.deactivate();
                            part.activate();
                            Command autosize = part.getCommand(new Request((Object)"autosize"));
                            autosize.execute();
                            return CommandResult.newOKCommandResult();
                        }
                    }));
                }
                DiagramCommandStack stack = part.getDiagramEditDomain().getDiagramCommandStack();
                stack.execute((Command)compound, progressMonitor);
            }
        }
    }

    public void refresh() {
        boolean forbidEnablement = false;
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            forbidEnablement = true;
        }
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            forbidEnablement = true;
        }
        if (forbidEnablement) {
            this.setEnabled(false);
            return;
        }
        Object selected = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selected instanceof IGraphicalEditPart) {
            selected = ((IGraphicalEditPart)selected).resolveSemanticElement();
        }
        if (!(selected instanceof Activity)) {
            forbidEnablement = true;
        }
        if (selected instanceof SubProcess) {
            forbidEnablement = true;
        }
        if (!((Activity)selected).getOrderedMessages().isEmpty() && ActivityType.VALUES_GATEWAYS.contains(this._type)) {
            forbidEnablement = true;
        }
        if (!((Activity)selected).getOrderedMessages().isEmpty() && ActivityType.EVENT_END_EMPTY_LITERAL.equals((Object)this._type)) {
            forbidEnablement = true;
        }
        if (!((Activity)selected).getOrderedMessages().isEmpty() && ActivityType.EVENT_INTERMEDIATE_EMPTY_LITERAL.equals((Object)this._type)) {
            forbidEnablement = true;
        }
        if (!((Activity)selected).getOrderedMessages().isEmpty() && ActivityType.EVENT_START_EMPTY_LITERAL.equals((Object)this._type)) {
            forbidEnablement = true;
        }
        if (forbidEnablement) {
            this.setEnabled(false);
            return;
        }
        if (((Activity)selected).getActivityType().getValue() == this.getActivityType().getValue()) {
            forbidEnablement = true;
        }
        if (!(this._type.getValue() != 1 || ((Activity)selected).getActivityType().getValue() == 0 && ((Activity)selected).getOrderedMessages().isEmpty())) {
            forbidEnablement = true;
        }
        this.setEnabled(!forbidEnablement);
    }

    public ActivityType getActivityType() {
        return this._type;
    }

    private abstract class MyCommand
    extends AbstractTransactionalCommand {
        public MyCommand(EObject elt) {
            super((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)elt), BpmnDiagramMessages.ChangeActivityTypeAction_settingActivityTypeCommand, MyCommand.getWorkspaceFiles((EObject)elt));
        }
    }
}

