/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.ui.IMenuItemWithDisableSupport;
import org.eclipse.stp.bpmn.diagram.ui.PopupMenuWithDisableSupport;
import org.eclipse.stp.bpmn.dnd.IDnDHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDragDropEditPolicy
extends GraphicalEditPolicy {
    private static WeakHashMap<Object, AdaptedCache> CACHE = new WeakHashMap();
    private EditPolicy previousEditPolicy;

    public BpmnDragDropEditPolicy(IGraphicalEditPart part) {
        EditPolicy policy = part.getEditPolicy((Object)"DragDropPolicy");
        if (policy != null) {
            this.previousEditPolicy = policy;
        }
    }

    public boolean understandsRequest(Request request) {
        boolean b = "drop_objects".equals(request.getType());
        b = b && request instanceof DropObjectsRequest && !((DropObjectsRequest)request).getObjects().isEmpty();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command getCommand(Request request) {
        if (!this.understandsRequest(request)) {
            if (this.previousEditPolicy != null) {
                return this.previousEditPolicy.getCommand(request);
            }
            return null;
        }
        final DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        List<IDnDHandler> dndHandlers = null;
        DropObjectsRequest dropObjectsRequest = dropRequest;
        synchronized (dropObjectsRequest) {
            AdaptedCache cache = CACHE.get(dropRequest.getObjects().iterator().next());
            if (cache != null && cache.size != dropRequest.getObjects().size()) {
                cache = null;
            }
            Object adapted = null;
            if (cache == null) {
                adapted = this.retrieveDnDHandlers(dropRequest.getObjects());
                Collections.sort(adapted, new Comparator<IDnDHandler>(){

                    @Override
                    public int compare(IDnDHandler o1, IDnDHandler o2) {
                        if (o1.getPriority() > o2.getPriority()) {
                            return -1;
                        }
                        if (o1.getPriority() < o2.getPriority()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                cache = new AdaptedCache();
                cache.result = new ArrayList<IDnDHandler>((Collection<IDnDHandler>)adapted);
                cache.size = dropRequest.getObjects().size();
                CACHE.put(dropRequest.getObjects().iterator().next(), cache);
            } else {
                adapted = new ArrayList<IDnDHandler>(cache.result);
            }
            dndHandlers = adapted;
        }
        if (dndHandlers == null || dndHandlers.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean isEnabled = false;
        for (IDnDHandler handler : dndHandlers) {
            int i = 0;
            while (i < handler.getItemCount()) {
                isEnabled = isEnabled || handler.isEnabled((IGraphicalEditPart)this.getHost(), i);
                ++i;
            }
        }
        if (!isEnabled) {
            dropRequest.setRequiredDetail(0);
        } else {
            dropRequest.setRequiredDetail(1);
        }
        final List<IDnDHandler> handlers = dndHandlers;
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), BpmnDiagramMessages.BpmnDragDropEditPolicy_command_name, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    DnDHandlerDelegateLabelProvider provider = new DnDHandlerDelegateLabelProvider();
                    ArrayList<DnDHandlerMenuItemData> items = new ArrayList<DnDHandlerMenuItemData>();
                    for (IDnDHandler handler : handlers) {
                        int i = 0;
                        while (i < handler.getItemCount()) {
                            DnDHandlerMenuItemData data = new DnDHandlerMenuItemData();
                            data.handler = handler;
                            data.index = i++;
                            items.add(data);
                        }
                    }
                    PopupMenuWithDisableSupport popupMenu = new PopupMenuWithDisableSupport(items, (ILabelProvider)provider);
                    PopupMenuCommand popupCmd = new PopupMenuCommand("", new Shell(), (PopupMenu)popupMenu);
                    popupCmd.execute(monitor, info);
                    if (popupCmd.getCommandResult().getStatus().getSeverity() != 0 || popupCmd.getCommandResult().getReturnValue() == null) {
                        CACHE.clear();
                        CommandResult commandResult = popupCmd.getCommandResult();
                        return commandResult;
                    }
                    DnDHandlerMenuItemData winner = (DnDHandlerMenuItemData)popupCmd.getCommandResult().getReturnValue();
                    Command co = winner.handler.getDropCommand((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost(), winner.index, dropRequest.getLocation().getCopy());
                    co.execute();
                    for (IDnDHandler handler : handlers) {
                        handler.dispose();
                    }
                }
                finally {
                    CACHE.clear();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return new ICommandProxy((ICommand)command);
    }

    private Command getAnnotationsDropCommand(final List<EAnnotation> annotations) {
        ICommandProxy co = new ICommandProxy((ICommand)new AbstractTransactionalCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), BpmnDiagramMessages.BpmnDragDropEditPolicy_annotation_drop_command, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject element = ((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost()).resolveSemanticElement();
                for (EAnnotation ann : annotations) {
                    SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)ann, (Object)EcorePackage.eINSTANCE.getEAnnotation_EModelElement(), (Object)element).execute();
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return co;
    }

    private List<IDnDHandler> retrieveDnDHandlers(List objects) {
        ArrayList<IDnDHandler> dndHandlers = new ArrayList<IDnDHandler>();
        for (Object dropped : objects) {
            Class[] cl;
            if (dropped instanceof IDnDHandler) {
                dndHandlers.add((IDnDHandler)dropped);
                continue;
            }
            HashMap factories = ((AdapterManager)Platform.getAdapterManager()).getFactories();
            Class[] classArray = cl = ((AdapterManager)Platform.getAdapterManager()).computeClassOrder(dropped.getClass());
            int n = cl.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                List clfactories = (List)factories.get(c.getName());
                if (clfactories != null) {
                    for (Object f : clfactories) {
                        IAdapterFactory factory = (IAdapterFactory)f;
                        Object adapted = factory.getAdapter(dropped, IDnDHandler.class);
                        if (adapted instanceof IDnDHandler) {
                            dndHandlers.add((IDnDHandler)adapted);
                            continue;
                        }
                        if (!(adapted instanceof List)) continue;
                        for (Object ad : (List)adapted) {
                            if (!(ad instanceof IDnDHandler)) continue;
                            dndHandlers.add((IDnDHandler)ad);
                        }
                    }
                }
                ++n2;
            }
        }
        return dndHandlers;
    }

    private Point getBalloonPosition(Point referencePoint) {
        Point lastRePointForBalloonPosition = referencePoint.getCopy();
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)lastRePointForBalloonPosition);
        Point thePoint = new Point();
        thePoint.setLocation(referencePoint);
        this.getHostFigure().translateToAbsolute((Translatable)thePoint);
        this.getHostFigure().translateToRelative((Translatable)thePoint);
        Control ctrl1 = this.getHost().getViewer().getControl();
        if (ctrl1 instanceof FigureCanvas) {
            FigureCanvas figureCanvas = (FigureCanvas)ctrl1;
            Viewport vp = figureCanvas.getViewport();
            Rectangle vpRect = vp.getClientArea();
            Rectangle rcBounds = this.getHostFigure().getBounds().getCopy();
            this.getHostFigure().translateToAbsolute((Translatable)rcBounds);
            this.getHostFigure().translateToRelative((Translatable)rcBounds);
            thePoint.y += vpRect.y;
            thePoint.x += vpRect.x;
        }
        return thePoint;
    }

    public EditPart getTargetEditPart(Request request) {
        if (this.understandsRequest(request)) {
            return this.getHost();
        }
        if (this.previousEditPolicy != null) {
            return this.previousEditPolicy.getTargetEditPart(request);
        }
        return null;
    }

    private static class AdaptedCache {
        public List<IDnDHandler> result;
        public int size;

        private AdaptedCache() {
        }
    }

    private class DnDHandlerDelegateLabelProvider
    extends LabelProvider {
        private DnDHandlerDelegateLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof DnDHandlerMenuItemData) {
                DnDHandlerMenuItemData data = (DnDHandlerMenuItemData)element;
                return data.handler.getMenuItemImage((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost(), data.index);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof DnDHandlerMenuItemData) {
                DnDHandlerMenuItemData data = (DnDHandlerMenuItemData)element;
                return data.handler.getMenuItemLabel((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost(), data.index);
            }
            return null;
        }
    }

    private class DnDHandlerMenuItemData
    implements IMenuItemWithDisableSupport {
        public IDnDHandler handler;
        public int index;

        private DnDHandlerMenuItemData() {
        }

        public boolean isEnabled() {
            return this.handler.isEnabled((IGraphicalEditPart)BpmnDragDropEditPolicy.this.getHost(), this.index);
        }
    }
}

