/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessSubProcessCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static final Dimension MIN_DIMENSION = SubProcessEditPart.EXPANDED_SIZE.getCopy().expand(0, -25);
    public static final Insets INSETS = SubProcessEditPart.INSETS;

    private Point divideByZoom(Point p) {
        ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
        p.x = (int)Math.floor((double)p.x / zoom.getZoom());
        p.y = (int)Math.floor((double)p.y / zoom.getZoom());
        return p;
    }

    private int divideByZoom(int i) {
        ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
        return (int)Math.floor((double)i / zoom.getZoom());
    }

    private Dimension divideByZoom(Dimension p) {
        ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
        p.width = (int)Math.floor((double)p.width / zoom.getZoom());
        p.height = (int)Math.floor((double)p.height / zoom.getZoom());
        return p;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        if (request.getMoveDelta().x == 0 && request.getMoveDelta().y == 0 && request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            return null;
        }
        List<Request> requests = this.chunkNegativeMove(request);
        CompoundCommand command = new CompoundCommand();
        command.add(super.getResizeChildrenCommand(request));
        boolean unexec = this.avoidOverlap(request, command);
        if (unexec) {
            return UnexecutableCommand.INSTANCE;
        }
        if (requests != null && !requests.isEmpty()) {
            for (Request negativeReq : requests) {
                Command co = this.getHost().getParent().getParent().getCommand(negativeReq);
                command.add(co);
            }
        } else {
            ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
            req.setEditParts(this.getHost().getParent());
            req.setCenteredResize(true);
            req.setSizeDelta(this.getMinSizeForSP(request));
            req.setMoveDelta(new Point(0, 0));
            if (req.getSizeDelta().height != 0 || req.getSizeDelta().width != 0) {
                Command parentCo = this.getHost().getParent().getParent().getCommand((Request)req);
                command.add(parentCo);
            }
        }
        this.makeSnapBackCommands(command, request);
        return command;
    }

    private void makeSnapBackCommands(CompoundCommand compound, ChangeBoundsRequest request) {
        for (Object epObj : request.getEditParts()) {
            if (!(epObj instanceof AbstractGraphicalEditPart)) continue;
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getSourceConnections(), compound);
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getTargetConnections(), compound);
        }
    }

    private void iterateOverConnections(List connections, CompoundCommand compound) {
        Request snapBack = new Request((Object)"snap_back");
        for (Object con : connections) {
            if (!(con instanceof ConnectionEditPart)) continue;
            LabelEditPart label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4012));
            if (label == null) {
                label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4013));
            }
            if (label == null) continue;
            compound.add(label.getCommand(snapBack));
        }
    }

    private List<Request> chunkNegativeMove(ChangeBoundsRequest request) {
        if (request == null) {
            return null;
        }
        boolean isNegative = false;
        Point maxMove = new Point(request.getMoveDelta().x, request.getMoveDelta().y);
        for (Object ep : request.getEditParts()) {
            int ymove;
            Point loc = ((GraphicalEditPart)ep).getFigure().getBounds().getLocation().getCopy();
            int xmove = loc.x + request.getMoveDelta().x - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
            if (xmove <= 0) {
                maxMove.x = -loc.x + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
                isNegative = true;
            }
            if ((ymove = loc.y + request.getMoveDelta().y - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top) > 0) continue;
            maxMove.y = -loc.y + SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top;
            isNegative = true;
        }
        Point p = new Point(request.getMoveDelta().x - maxMove.x, request.getMoveDelta().y - maxMove.y);
        request.setMoveDelta(maxMove);
        if (isNegative) {
            int toobigy = request.getMoveDelta().y + request.getSizeDelta().height;
            int maxHeight = 0;
            for (Object ep : request.getEditParts()) {
                maxHeight = Math.max(maxHeight, ((GraphicalEditPart)ep).getFigure().getBounds().height + ((GraphicalEditPart)ep).getFigure().getBounds().y);
            }
            if (this.getHostFigure().getBounds().height < toobigy + maxHeight) {
                isNegative = false;
            }
        }
        if (isNegative) {
            int toobigx = request.getMoveDelta().x + request.getSizeDelta().width;
            int maxWidth = 0;
            for (Object ep : request.getEditParts()) {
                maxWidth = Math.max(maxWidth, ((GraphicalEditPart)ep).getFigure().getBounds().width + ((GraphicalEditPart)ep).getFigure().getBounds().x);
            }
            if (this.getHostFigure().getBounds().width < toobigx + maxWidth) {
                isNegative = false;
            }
        }
        if (!isNegative) {
            return null;
        }
        ChangeBoundsRequest compartmentRequest = new ChangeBoundsRequest((Object)"resize children");
        Dimension d = new Dimension(Math.abs(p.x), Math.abs(p.y));
        compartmentRequest.setMoveDelta(p);
        compartmentRequest.setSizeDelta(d);
        compartmentRequest.setEditParts(this.getHost().getParent());
        ChangeBoundsRequest childrenRequest = new ChangeBoundsRequest((Object)"resize children");
        Point childrenMove = new Point(-p.x, -p.y);
        childrenRequest.setMoveDelta(childrenMove);
        childrenRequest.setEditParts(new ArrayList(this.getHost().getChildren()));
        childrenRequest.getEditParts().removeAll(request.getEditParts());
        LinkedList<Request> requests = new LinkedList<Request>();
        requests.add((Request)compartmentRequest);
        if (!childrenRequest.getEditParts().isEmpty()) {
            requests.add((Request)childrenRequest);
        }
        return requests;
    }

    private Dimension getMinSizeForSP(CreateRequest request) {
        Dimension requestSize;
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(Collections.EMPTY_LIST);
        Dimension dim = this.getMinSizeForSP(req);
        Dimension dimension = requestSize = request.getSize() == null ? null : request.getSize().getCopy();
        if (requestSize == null || requestSize.width == -1 && requestSize.height == -1) {
            List descriptors;
            requestSize = new Dimension(150, 100);
            if (request instanceof CreateViewRequest && !(descriptors = ((CreateViewRequest)request).getViewDescriptors()).isEmpty()) {
                CreateViewRequest.ViewDescriptor desc = (CreateViewRequest.ViewDescriptor)descriptors.get(0);
                IElementType type = (IElementType)desc.getElementAdapter().getAdapter(IElementType.class);
                requestSize = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
            }
        }
        Dimension initialdim = ((GraphicalEditPart)this.getHost()).getFigure().getSize().getCopy();
        if (initialdim.height == 0 && initialdim.width == 0) {
            return initialdim;
        }
        Point loc = request.getLocation().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)loc);
        this.getHostFigure().translateToRelative((Translatable)loc);
        Rectangle rect = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        loc.x -= rect.x;
        loc.y -= rect.y;
        dim.width = Math.max(dim.width, loc.x + requestSize.width + INSETS.getWidth());
        dim.height = Math.max(dim.height, loc.y + requestSize.height + INSETS.getHeight());
        dim.width = dim.width - initialdim.width + INSETS.getWidth();
        dim.height = dim.height - initialdim.height + INSETS.getHeight();
        if (dim.width < 0) {
            dim.width = 0;
        }
        if (dim.height < 0) {
            dim.height = 0;
        }
        return dim;
    }

    protected boolean considerPartForMinimumSizeComputations(IGraphicalEditPart childEditPart) {
        EObject domainObject = childEditPart.resolveSemanticElement();
        return domainObject == null || !(domainObject instanceof Artifact);
    }

    private Dimension getMinSizeForSP(ChangeBoundsRequest request) {
        Dimension initialdim = ((GraphicalEditPart)this.getHost().getParent()).getFigure().getSize().getCopy();
        Dimension dim = MIN_DIMENSION.getCopy();
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)child;
            if (!this.considerPartForMinimumSizeComputations(part)) continue;
            Rectangle r = part.getFigure().getBounds().getCopy();
            int w = r.x + r.width;
            if (request.getEditParts().contains(part) || this.getHost().getViewer().getSelectedEditParts().contains(part)) {
                w += this.divideByZoom((Dimension)request.getSizeDelta()).width + this.divideByZoom((Point)request.getMoveDelta()).x;
            }
            dim.width = Math.max(dim.width, w);
            int h = r.y + r.height;
            if (request.getEditParts().contains(part) || this.getHost().getViewer().getSelectedEditParts().contains(part)) {
                h += this.divideByZoom((Dimension)request.getSizeDelta()).height + this.divideByZoom((Point)request.getMoveDelta()).y;
            }
            dim.height = Math.max(dim.height, h);
        }
        SubProcessEditPart.SubProcessFigure spFigure = ((SubProcessEditPart)this.getHost().getParent()).getPrimaryShape();
        dim.width = dim.width - initialdim.width + INSETS.getWidth();
        dim.height = dim.height - initialdim.height + spFigure.getFigureSubProcessBorderFigure().getBorderHeight() + spFigure.getFigureSubProcessNameFigure().getBounds().height + INSETS.getHeight();
        dim.width = Math.max(dim.width, 0);
        dim.height = Math.max(dim.height, 0);
        return dim;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Point loc = request.getLocation().getCopy();
        Point here = this.getHostFigure().getParent().getBounds().getCopy().getLocation();
        if (here.x != 0 || here.y != 0) {
            int correction;
            this.getHostFigure().getParent().translateToAbsolute((Translatable)here);
            this.getHostFigure().translateToAbsolute((Translatable)loc);
            this.getHostFigure().translateToRelative((Translatable)loc);
            loc.x = loc.x - here.x - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.left;
            loc.y = loc.y - here.y - SubProcessSubProcessCompartmentXYLayoutEditPolicy.INSETS.top;
            if (loc.x <= 0) {
                correction = -loc.x + 1;
                request.getLocation().x += correction;
            }
            if (loc.y <= 0) {
                correction = -loc.y + 1;
                request.getLocation().y += correction;
            }
        }
        CompoundCommand command = new CompoundCommand();
        command.add(super.getCreateCommand(request));
        ChangeBoundsRequest thisSizeReq = new ChangeBoundsRequest((Object)"resize children");
        thisSizeReq.setCenteredResize(true);
        thisSizeReq.setEditParts(this.getHost().getParent());
        thisSizeReq.setSizeDelta(this.getMinSizeForSP(request));
        if (thisSizeReq.getSizeDelta().height == 0 && thisSizeReq.getSizeDelta().width == 0) {
            return command;
        }
        Command co = this.getHost().getParent().getParent().getCommand((Request)thisSizeReq);
        command.add(co);
        return command;
    }

    private boolean avoidOverlap(ChangeBoundsRequest request, CompoundCommand compound) {
        HashMap<IGraphicalEditPart, Rectangle> old2newBounds = new HashMap<IGraphicalEditPart, Rectangle>();
        Dimension sizeDelta = this.divideByZoom(new Dimension(request.getSizeDelta()));
        Point moveDelta = this.divideByZoom(new Point(request.getMoveDelta()));
        for (Object ep : request.getEditParts()) {
            Rectangle rect = ((IGraphicalEditPart)ep).getFigure().getBounds().getCopy();
            Rectangle newRect = rect.resize(sizeDelta).translate(moveDelta);
            old2newBounds.put((IGraphicalEditPart)ep, newRect);
        }
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)child;
            if (request.getEditParts().contains(part)) continue;
            Rectangle childInnerBounds = new Rectangle(part.getFigure().getBounds());
            childInnerBounds.shrink(4, 4);
            for (Map.Entry bounds : old2newBounds.entrySet()) {
                boolean r;
                Rectangle requestedNewBounds = (Rectangle)old2newBounds.get(bounds.getKey());
                if (!requestedNewBounds.intersects(childInnerBounds) || !(r = this.avoidOverlap((IGraphicalEditPart)bounds.getKey(), requestedNewBounds, part, compound))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean avoidOverlap(IGraphicalEditPart movedPart, Rectangle requestedNewBounds, IGraphicalEditPart overlappingPart, CompoundCommand theCommand) {
        return true;
    }
}

