/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.swt.graphics.Cursor;

public class MultipleShapesMoveTool
extends SimpleDragTracker {
    private IFigure guideline;
    private Integer _initialPosition;
    private List<IGraphicalEditPart> _movingShapes = Collections.EMPTY_LIST;
    private IGraphicalEditPart _container;

    public MultipleShapesMoveTool() {
        this.guideline = new GuideEditPart.GuideLineFigure();
        this.guideline.setVisible(false);
    }

    protected void eraseSourceFeedback() {
        if (this.guideline.getParent() != null) {
            this.guideline.getParent().remove(this.guideline);
        }
        if (this._container != null) {
            this._container.eraseSourceFeedback(this.getSourceRequest());
        }
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        for (IGraphicalEditPart part : this._movingShapes) {
            part.eraseSourceFeedback((Request)request);
        }
    }

    protected Command getCommand() {
        return this._container.getCommand(this.getSourceRequest());
    }

    protected String getCommandName() {
        return "move children";
    }

    protected int getCurrentPositionZoomed() {
        Point pt = this.getLocation();
        ((IGraphicalEditPart)((IDiagramGraphicalViewer)this.getCurrentViewer()).getRootEditPart().getChildren().get(0)).getFigure().translateToRelative((Translatable)pt);
        return pt.x;
    }

    protected int getCurrentPosition() {
        int position = this.getCurrentPositionZoomed();
        ZoomManager zoomManager = ((DiagramRootEditPart)this.getCurrentViewer().getRootEditPart()).getZoomManager();
        if (zoomManager != null) {
            position = (int)Math.round((double)position / zoomManager.getZoom());
        }
        return position;
    }

    protected String getDebugName() {
        return "Multiple Shape Horizontal Move";
    }

    protected Cursor getDefaultCursor() {
        if (this.isMoveValid()) {
            return SharedCursors.SIZEWE;
        }
        if (this.getState() == 4) {
            return SharedCursors.SIZEWE;
        }
        return SharedCursors.ARROW;
    }

    private boolean isMoveValid() {
        if (this.getCurrentViewer() == null || this.getCurrentInput() == null) {
            return true;
        }
        EditPart obj = this.getCurrentViewer().findObjectAt(this.getCurrentInput().getMouseLocation());
        return obj instanceof IGraphicalEditPart && ((IGraphicalEditPart)obj).resolveSemanticElement() instanceof Graph;
    }

    public boolean handleButtonDown(int button) {
        IGraphicalEditPart parent;
        EditPart underMouse = this.getCurrentViewer().findObjectAt(this.getCurrentInput().getMouseLocation());
        if (!(underMouse instanceof IGraphicalEditPart)) {
            return true;
        }
        this.stateTransition(1, 4);
        this._initialPosition = this.getCurrentPosition();
        this._container = (IGraphicalEditPart)underMouse;
        ArrayList<IGraphicalEditPart> rightChildren = new ArrayList<IGraphicalEditPart>();
        if (this._container instanceof SubProcessSubProcessBorderCompartmentEditPart || this._container instanceof SubProcessNameEditPart) {
            this._container = (IGraphicalEditPart)this._container.getParent();
        }
        if ((this._container instanceof SubProcessEditPart || this._container.resolveSemanticElement() instanceof IdentifiableNode && !(this._container.resolveSemanticElement() instanceof Graph)) && (parent = this.findParent(this._container.getParent())) != null) {
            if (this._container instanceof TextCompartmentEditPart) {
                this._container = (IGraphicalEditPart)this._container.getParent();
            }
            rightChildren.add(this._container);
            this._container = parent;
        }
        if (this._container.resolveSemanticElement() instanceof Graph) {
            List children = null;
            if (this._container instanceof PoolEditPart) {
                PoolPoolCompartmentEditPart compartment = (PoolPoolCompartmentEditPart)((PoolEditPart)this._container).getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001));
                children = compartment.getChildren();
            } else if (this._container instanceof PoolPoolCompartmentEditPart) {
                children = ((PoolPoolCompartmentEditPart)this._container).getChildren();
            } else if (this._container instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                children = ((SubProcessSubProcessBodyCompartmentEditPart)this._container).getChildren();
            }
            if (children == null) {
                throw new IllegalArgumentException("The part " + this._container + " did not contain elements");
            }
            for (Object child : children) {
                if (!(child instanceof IGraphicalEditPart)) continue;
                Point loc = ((IGraphicalEditPart)child).getFigure().getBounds().getLocation().getCopy();
                ((IGraphicalEditPart)child).getFigure().translateToAbsolute((Translatable)loc);
                ((DiagramEditPart)this.getCurrentViewer().getContents()).getFigure().translateToRelative((Translatable)loc);
                if (loc.x <= this._initialPosition) continue;
                rightChildren.add((IGraphicalEditPart)child);
            }
        }
        this._movingShapes = rightChildren;
        this.updateSourceRequest();
        this.showSourceFeedback();
        return true;
    }

    private IGraphicalEditPart findParent(Object part) {
        if (part instanceof IGraphicalEditPart) {
            if (((IGraphicalEditPart)part).resolveSemanticElement() instanceof Graph) {
                return (IGraphicalEditPart)part;
            }
            return this.findParent(((IGraphicalEditPart)part).getParent());
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        this.eraseSourceFeedback();
        this._movingShapes = Collections.EMPTY_LIST;
        this._initialPosition = null;
        this.setState(1);
        this._container = null;
        return true;
    }

    protected boolean movedPastThreshold() {
        return true;
    }

    protected void showSourceFeedback() {
        if (this.guideline.getParent() == null) {
            this.addFeedback(this.guideline);
        }
        Rectangle bounds = Rectangle.SINGLETON.getCopy();
        bounds.x = this.getCurrentPositionZoomed();
        Rectangle containerBounds = this._container.getFigure().getBounds().getCopy();
        this._container.getFigure().translateToAbsolute((Translatable)containerBounds);
        ((DiagramEditPart)this.getCurrentViewer().getContents()).getFigure().translateToRelative((Translatable)containerBounds);
        bounds.y = containerBounds.y;
        bounds.width = 1;
        bounds.height = containerBounds.height;
        this.guideline.setBounds(bounds);
        this.guideline.setVisible(this.getState() == 4);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setMoveDelta(((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().getCopy());
        for (IGraphicalEditPart part : this._movingShapes) {
            part.showSourceFeedback((Request)request);
        }
    }

    protected Request createSourceRequest() {
        return new ChangeBoundsRequest((Object)this.getCommandName());
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        int moved = this.getCurrentPosition() - this._initialPosition;
        ((ChangeBoundsRequest)this.getSourceRequest()).setMoveDelta(new Point(moved, 0));
        ((ChangeBoundsRequest)this.getSourceRequest()).setEditParts(this._movingShapes);
    }
}

