/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.DataObjectEditPart;
import org.eclipse.swt.graphics.Cursor;

public class TaskDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    private static final boolean DO_FIX_LOCATION_TO_AVOID_OVERLAP = true;
    private static final boolean DO_CACHE_LAST_EXECUTABLE_COMMAND = true;
    private Command _mostRecentExecutableCommand;
    private ChangeBoundsRequest _mostRecentTargetForExecutableCommand;
    private Point _mostRecentExecutableLocation;
    private Point _mostRecentExecutableMoveDelta;
    private Dimension _mostRecentExecutableSizeDelta;
    private Object _mostExecutableRecentType;
    private int _srcHalfHeight = 0;
    private int _srcHalfWidth = 0;
    private ChangeBoundsRequest clonedLastExecutableRequest;
    private int dLeft = -1;
    private int dRight;
    private int dTop;
    private int dBottom;
    private EObject _sourceModel;
    private Rectangle _tmp = new Rectangle();
    private Rectangle _tmp2 = new Rectangle();
    private static int MAX_DELTA_FROM_LAST_EXECUTABLE_POSITION = 32;
    private static final int _FLAG_SOURCE_FEEDBACK = 256;

    public TaskDragEditPartsTrackerEx(IGraphicalEditPart sourceEditPart) {
        super((EditPart)sourceEditPart);
        Rectangle srcBounds = sourceEditPart.getFigure().getBounds();
        this._sourceModel = sourceEditPart.getPrimaryView().getElement();
        if (srcBounds.height > 0) {
            this._srcHalfHeight = srcBounds.height / 2;
        }
        if (srcBounds.width > 0) {
            this._srcHalfWidth = srcBounds.width / 2;
        }
    }

    private boolean isReparentEnabled() {
        if (this.getTargetEditPart() == null) {
            return false;
        }
        IGraphicalEditPart source = (IGraphicalEditPart)this.getSourceEditPart();
        if (source.resolveSemanticElement() instanceof Activity) {
            Activity a = (Activity)source.resolveSemanticElement();
            if (!a.getIncomingEdges().isEmpty() || !a.getOutgoingEdges().isEmpty()) {
                return false;
            }
            Pool targetPool = this.getPool(((IGraphicalEditPart)this.getTargetEditPart()).resolveSemanticElement());
            if (targetPool == null) {
                return false;
            }
            for (Object msg : a.getOutgoingMessages()) {
                Activity target = ((MessagingEdge)msg).getTarget();
                if (!targetPool.equals(this.getPool(target))) continue;
                return false;
            }
            for (Object msg : a.getIncomingMessages()) {
                Activity src = ((MessagingEdge)msg).getSource();
                if (!targetPool.equals(this.getPool(src))) continue;
                return false;
            }
        } else if (source.resolveSemanticElement() instanceof Artifact) {
            return this.getTargetEditPart() != this.getSourceEditPart().getParent() && this.getTargetEditPart() != null;
        }
        return this.getCurrentInput().isShiftKeyDown();
    }

    private Pool getPool(Object elt) {
        if (elt instanceof Pool) {
            return (Pool)elt;
        }
        if (elt instanceof Activity && ((Activity)elt).getEventHandlerFor() != null) {
            return this.getPool(((Activity)elt).getEventHandlerFor());
        }
        if (elt instanceof Vertex) {
            return this.getPool(((Vertex)elt).getGraph());
        }
        return null;
    }

    protected boolean isMove() {
        boolean isMove = !this.isReparentEnabled();
        return isMove;
    }

    protected boolean isCloneActive() {
        return false;
    }

    protected Command getCommand() {
        if (this.isReparentEnabled()) {
            this._mostRecentExecutableCommand = null;
            Request request = this.getTargetRequest();
            if (this.getTargetEditPart() != null) {
                request.setType((Object)"add children");
                Command command = this.getTargetEditPart().getCommand(request);
                return command;
            }
            return UnexecutableCommand.INSTANCE;
        }
        Command res = super.getCommand();
        if (res.canExecute()) {
            this._mostRecentExecutableCommand = res;
            this._mostRecentTargetForExecutableCommand = (ChangeBoundsRequest)this.getTargetRequest();
            this._mostRecentExecutableLocation = this._mostRecentTargetForExecutableCommand.getLocation();
            this._mostRecentExecutableSizeDelta = this._mostRecentTargetForExecutableCommand.getSizeDelta();
            this._mostRecentExecutableMoveDelta = this._mostRecentTargetForExecutableCommand.getMoveDelta();
            this._mostExecutableRecentType = this._mostRecentTargetForExecutableCommand.getType();
            this.clonedLastExecutableRequest = null;
        } else if (this._mostRecentExecutableCommand != null) {
            if (Math.abs(this._mostRecentExecutableLocation.x - this.getLocation().x) > MAX_DELTA_FROM_LAST_EXECUTABLE_POSITION + this._srcHalfWidth || Math.abs(this._mostRecentExecutableLocation.y - this.getLocation().y) > MAX_DELTA_FROM_LAST_EXECUTABLE_POSITION + this._srcHalfHeight) {
                return res;
            }
            return this._mostRecentExecutableCommand;
        }
        return res;
    }

    protected Point getLocation() {
        if (this.isMove() && this.getTargetEditPart() != null && this.getTargetEditPart() instanceof IGraphicalEditPart) {
            IGraphicalEditPart currTarget = (IGraphicalEditPart)this.getTargetEditPart();
            if (currTarget instanceof DataObjectEditPart) {
                currTarget = (IGraphicalEditPart)currTarget.getParent();
            }
            if (currTarget.getPrimaryView() == null || currTarget.getPrimaryView().getElement() == null) {
                return super.getLocation();
            }
            if (currTarget.getPrimaryView().getElement().equals(this._sourceModel.eContainer())) {
                IGraphicalEditPart srcEp = (IGraphicalEditPart)this.getSourceEditPart();
                this._tmp2.setBounds(srcEp.getFigure().getBounds());
                srcEp.getFigure().translateToAbsolute((Translatable)this._tmp2);
                for (Object ep : currTarget.getChildren()) {
                    if (ep == srcEp || !(ep instanceof IGraphicalEditPart) || ep instanceof DataObjectEditPart) continue;
                    IGraphicalEditPart sibling = (IGraphicalEditPart)ep;
                    this._tmp.setBounds(sibling.getFigure().getBounds());
                    sibling.getFigure().translateToAbsolute((Translatable)this._tmp);
                    if (!this._tmp.intersects(this._tmp2)) continue;
                    Point currLocation = super.getLocation();
                    this._tmp.intersect(this._tmp2);
                    if (this._tmp.width > this._tmp.height) {
                        if (currLocation.y > this._tmp.y) {
                            return new Point(currLocation.x, currLocation.y + this._tmp.height);
                        }
                        return new Point(currLocation.x, currLocation.y - this._tmp.height);
                    }
                    if (currLocation.x > this._tmp.x) {
                        return new Point(currLocation.x + this._tmp.width, currLocation.y);
                    }
                    return new Point(currLocation.x - this._tmp.width, currLocation.y);
                }
                currTarget = null;
            }
            if (currTarget != null) {
                this._tmp.setBounds(currTarget.getFigure().getBounds());
                currTarget.getFigure().translateToAbsolute((Translatable)this._tmp);
                Point currLocation = super.getLocation();
                int dx = 0;
                int dy = 0;
                this.computeSourceDistanceFromBorders();
                if (this._tmp.x + this._tmp.width / 2 > currLocation.x) {
                    dx = currLocation.x - this._tmp.x;
                    dx += this.dRight;
                } else {
                    dx = currLocation.x - this._tmp.x - this._tmp.width;
                    dx -= this.dLeft;
                }
                if (this._tmp.y + this._tmp.height / 2 > currLocation.y) {
                    dy = currLocation.y - this._tmp.y;
                    dy += this.dBottom;
                } else {
                    dy = currLocation.y - this._tmp.y - this._tmp.height;
                    dy -= this.dTop;
                }
                if (Math.abs(dx) > Math.abs(dy)) {
                    return new Point(currLocation.x, currLocation.y - dy);
                }
                return new Point(currLocation.x - dx, currLocation.y);
            }
        }
        return super.getLocation();
    }

    private void computeSourceDistanceFromBorders() {
        if (this.dLeft != -1) {
            return;
        }
        this._tmp.setBounds(((IGraphicalEditPart)this.getSourceEditPart()).getFigure().getBounds());
        ((IGraphicalEditPart)this.getSourceEditPart()).getFigure().translateToAbsolute((Translatable)this._tmp);
        Point start = this.getStartLocation();
        this.dLeft = start.x - this._tmp.x;
        this.dRight = this._tmp.x + this._tmp.width - start.x;
        this.dTop = start.y - this._tmp.y;
        this.dBottom = this._tmp.y + this._tmp.height - start.y;
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        if (this._mostRecentExecutableCommand != null) {
            if (this.clonedLastExecutableRequest == null) {
                this.clonedLastExecutableRequest = new ChangeBoundsRequest(this._mostExecutableRecentType);
                if (this._mostRecentExecutableSizeDelta != null) {
                    this.clonedLastExecutableRequest.setSizeDelta(this._mostRecentExecutableSizeDelta);
                }
                if (this._mostRecentExecutableMoveDelta != null) {
                    this.clonedLastExecutableRequest.setMoveDelta(this._mostRecentExecutableMoveDelta);
                }
                if (this._mostRecentExecutableLocation != null) {
                    this.clonedLastExecutableRequest.setLocation(this._mostRecentExecutableLocation);
                }
                this.clonedLastExecutableRequest.setEditParts(this._mostRecentTargetForExecutableCommand.getEditParts());
            }
            int i = 0;
            while (i < editParts.size()) {
                EditPart editPart = (EditPart)editParts.get(i);
                editPart.showSourceFeedback((Request)this.clonedLastExecutableRequest);
                ++i;
            }
        } else {
            int i = 0;
            while (i < editParts.size()) {
                EditPart editPart = (EditPart)editParts.get(i);
                editPart.showSourceFeedback(this.getTargetRequest());
                ++i;
            }
        }
        this.setFlag(256, true);
    }

    protected Cursor calculateCursor() {
        Command command = this.getCurrentCommand();
        if (command == null || !command.canExecute()) {
            return this.getDisabledCursor();
        }
        if (this.isInState(4) || this.isInState(32)) {
            if (this.isMove()) {
                return SharedCursors.HAND;
            }
            if (this.isReparentEnabled()) {
                return SharedCursors.CURSOR_TREE_MOVE;
            }
        }
        return super.calculateCursor();
    }

    protected void executeCurrentCommand() {
        Command curCommand = this.getCurrentCommand();
        if (curCommand != null && curCommand.canExecute()) {
            this.executeCommand(curCommand);
        }
        this.setCurrentCommand(null);
    }
}

