/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.internal.viewers;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.CommonPlugin;
import org.eclipse.stp.sc.common.internal.viewers.StpRuntimeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;

public class StpRuntimeCheckComposite
extends StpRuntimeComposite {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(StpRuntimeCheckComposite.class);
    private static final String DEFAULT_PREFIX = "default";

    public StpRuntimeCheckComposite(Composite parent, int style, StpRuntimeComposite.SelectionListener listener2, String[] moduleTypes) {
        super(parent, style, listener2, moduleTypes);
        ((CheckboxTableViewer)this.tableViewer).addCheckStateListener((ICheckStateListener)new DefaultCheckStateListener());
        this.setCheckState((CheckboxTableViewer)this.tableViewer);
        if (this.table.getItemCount() > 0) {
            TableColumn[] columns = this.table.getColumns();
            int i = 0;
            while (i < columns.length) {
                columns[i].pack();
                ++i;
            }
            this.table.pack();
        }
    }

    protected void createTableViewer() {
        this.tableViewer = new CheckboxTableViewer(this.table);
    }

    protected void createTable() {
        this.table = new Table((Composite)this, 68388);
    }

    protected void setCheckState(CheckboxTableViewer viewer) {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < this.table.getItemCount()) {
            IRuntime runtime = (IRuntime)viewer.getElementAt(i);
            String moduleType = runtime.getRuntimeType().getModuleTypes()[0].getId();
            String defaultRuntimeId = store.getString(DEFAULT_PREFIX + moduleType);
            if (runtime.getId().equals(defaultRuntimeId)) {
                viewer.setChecked((Object)runtime, true);
            } else {
                viewer.setChecked((Object)runtime, false);
            }
            ++i;
        }
    }

    public void updateDefault(IRuntime removeRuntime) {
        if (removeRuntime != null) {
            String moduleType = removeRuntime.getRuntimeType().getModuleTypes()[0].getId();
            IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
            String defaultRuntime = store.getString(DEFAULT_PREFIX + moduleType);
            if (defaultRuntime.equals(removeRuntime.getId())) {
                store.setValue(DEFAULT_PREFIX + moduleType, "");
            }
        }
        int items = this.table.getItemCount();
        int index = 0;
        while (index < items) {
            IRuntime rt = (IRuntime)this.tableViewer.getElementAt(index);
            String moduleType = rt.getRuntimeType().getModuleTypes()[0].getId();
            if (!this.isDefaultRuntimeExists(moduleType)) {
                this.selectDefaultRuntime(rt);
            }
            ++index;
        }
    }

    protected boolean isDefaultRuntimeExists(String moduleType) {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        String defaultRuntimeId = store.getString(DEFAULT_PREFIX + moduleType);
        if (defaultRuntimeId == null || defaultRuntimeId.equals("")) {
            return false;
        }
        int items = this.table.getItemCount();
        int index = 0;
        while (index < items) {
            IRuntime rt = (IRuntime)this.tableViewer.getElementAt(index);
            if (rt.getId().equals(defaultRuntimeId)) {
                return true;
            }
            ++index;
        }
        store.setValue(DEFAULT_PREFIX + moduleType, null);
        return false;
    }

    protected void selectDefaultRuntime(IRuntime runtime) {
        String moduleType = runtime.getRuntimeType().getModuleTypes()[0].getId();
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        store.setValue(DEFAULT_PREFIX + moduleType, runtime.getId());
        LOG.debug((Object)("set default runtime for " + moduleType + " runtime id:" + runtime.getId()));
        int items = this.table.getItemCount();
        int index = 0;
        while (index < items) {
            IRuntime rt = (IRuntime)this.tableViewer.getElementAt(index);
            if (rt.getId() == runtime.getId()) {
                if (!((CheckboxTableViewer)this.tableViewer).getChecked((Object)rt)) {
                    ((CheckboxTableViewer)this.tableViewer).setChecked((Object)rt, true);
                }
            } else if (this.supportSameModule(rt, runtime) && ((CheckboxTableViewer)this.tableViewer).getChecked((Object)rt)) {
                LOG.debug((Object)("unselect previous default runtime:" + rt.getId()));
                ((CheckboxTableViewer)this.tableViewer).setChecked((Object)rt, false);
            }
            ++index;
        }
    }

    private boolean supportSameModule(IRuntime rt1, IRuntime rt2) {
        IModuleType[] types;
        IModuleType[] iModuleTypeArray = types = rt1.getRuntimeType().getModuleTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleType type1 = iModuleTypeArray[n2];
            IModuleType[] iModuleTypeArray2 = rt2.getRuntimeType().getModuleTypes();
            int n3 = iModuleTypeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IModuleType type2 = iModuleTypeArray2[n4];
                if (type1.getId().equals(type2.getId())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public class DefaultCheckStateListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            IRuntime runtime = (IRuntime)event.getElement();
            LOG.debug((Object)("runtime selected:" + runtime.getId()));
            if (checked) {
                StpRuntimeCheckComposite.this.selectDefaultRuntime(runtime);
            }
        }
    }
}

