/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.validator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.validator.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnXMLTreeBuilder {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnXMLTreeBuilder.class);
    public static final String ATTR_XMLNS = "xmlns";
    public static final String ATTR_PREFIX = "tns";
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;

    public AnnXMLTreeBuilder() {
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setNamespaceAware(true);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError e) {
            LOG.error((Object)"factory error", (Throwable)e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"parser config error", (Throwable)e);
        }
    }

    public Document buildTreeFromOneAnn(NormalAnnotation annotation) {
        Document document = this.builder.newDocument();
        Name typeName = annotation.getTypeName();
        String namespaceURI = XMLUtils.getNSFromClsName(typeName.getFullyQualifiedName());
        String rootName = typeName.getFullyQualifiedName();
        if (rootName.indexOf(".") > 0) {
            rootName = rootName.substring(rootName.lastIndexOf(".") + 1, rootName.length());
        }
        Element root = document.createElementNS(namespaceURI, rootName);
        root.setAttribute("xmlns:tns", namespaceURI);
        root.setPrefix(ATTR_PREFIX);
        for (MemberValuePair member : annotation.values()) {
            Element child = document.createElement(member.getName().getFullyQualifiedName());
            String strValue = this.convertExpressToStr(member.getValue());
            child.setTextContent(strValue);
            root.appendChild(child);
        }
        document.appendChild(root);
        LOG.debug((Object)("xml generate from ann:" + XMLUtils.getXMLAsString(document)));
        return document;
    }

    private String convertExpressToStr(Expression exp) {
        if (exp instanceof StringLiteral) {
            return ((StringLiteral)exp).getLiteralValue();
        }
        if (exp instanceof BooleanLiteral) {
            boolean value = ((BooleanLiteral)exp).booleanValue();
            return Boolean.toString(value);
        }
        if (exp instanceof NumberLiteral) {
            ((NumberLiteral)exp).getToken();
        }
        LOG.debug((Object)("Unsupported express type:" + exp.getClass().getName()));
        return exp.toString();
    }

    public Document buildTreeFromJavaUnit() {
        return null;
    }
}

