/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.wst.server.core.IRuntime;

public final class TestUtilities
extends WorkbenchUtils {
    static String TEST_CXF_RUNTIME_ID = "test_cxf_runtime";
    static String TEST_CXF_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.cxf.20";

    private TestUtilities() {
    }

    public static void checkTable(Table table, String[] columns) {
        Assert.assertEquals((String)"Wrong number of columns", (int)columns.length, (int)table.getColumns().length);
        Assert.assertTrue((String)"Table should be visible", (boolean)table.getVisible());
        int expectedColumnWidth = table.getSize().x / columns.length;
        int i = 0;
        while (i < columns.length) {
            Assert.assertEquals((String)("Wrong title for column " + i), (String)columns[i], (String)table.getColumn(i).getText());
            Assert.assertTrue((String)("Column " + i + " should be resizeable"), (boolean)table.getColumn(i).getResizable());
            Assert.assertTrue((String)("Column " + i + " width " + table.getColumn(i).getWidth() + " not within +/- 25% of " + expectedColumnWidth), ((double)table.getColumn(i).getWidth() >= (double)expectedColumnWidth * 0.8 && (double)table.getColumn(i).getWidth() <= (double)expectedColumnWidth * 1.4 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"Header should be visible", (boolean)table.getHeaderVisible());
        Assert.assertTrue((String)"Grid lines should be visible", (boolean)table.getLinesVisible());
    }

    public static void checkVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, true);
    }

    public static void checkNotVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, false);
    }

    public static void checkVisible(Control control, String name, boolean visible) {
        Assert.assertNotNull((String)("Control " + name + " should not be null"), (Object)control);
        if (visible) {
            Assert.assertTrue((String)("Control " + name + " should  be visible"), (boolean)control.isVisible());
            Assert.assertTrue((String)("Control " + name + " should not be disposed"), (!control.isDisposed() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Control " + name + " should not be visible"), (control.isDisposed() || !control.isVisible() ? 1 : 0) != 0);
        }
    }

    public static void setupJavaProject(IProject project) throws Exception {
        TestUtilities.setupBasicJavaProject((IProject)project);
        if (!project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
            ScNature.addToProject((IProject)project, (String)"JavaFrist");
        }
    }

    public static void setupTestRuntimeInfo(IProject project) {
        String runtimeId = TestUtilities.createTestRuntime();
        RuntimeCore.setRuntimeID((IProject)project, (String)runtimeId);
        RuntimeCore.setRuntimeType((IProject)project, (String)TEST_CXF_RUNTIME_TYPE);
    }

    public static String createTestRuntime() {
        try {
            IRuntime runtime = RuntimeCore.getRuntime((String)TEST_CXF_RUNTIME_ID);
            String runtimeId = null;
            if (runtime == null) {
                String kitLocation = System.getProperty("jaxws_kit_location");
                Path kitPath = new Path(kitLocation);
                runtimeId = RuntimeCore.creatRuntime((String)TEST_CXF_RUNTIME_TYPE, (String)TEST_CXF_RUNTIME_ID, (IPath)kitPath);
            } else {
                runtimeId = runtime.getId();
            }
            return runtimeId;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    public static IProject createTestCeltixProject(String projectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            newProject = TestUtilities.createProject((String)projectName, null);
        } else {
            try {
                newProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        TestUtilities.setupTestRuntimeInfo(newProject);
        return newProject;
    }

    public static void delay(long durationInMilliseconds) {
        Display display = Display.getCurrent();
        if (display != null) {
            long t2 = System.currentTimeMillis() + durationInMilliseconds;
            while (System.currentTimeMillis() < t2) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(durationInMilliseconds);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void waitForJobs(long durationInMilliseconds) {
        while (Job.getJobManager().currentJob() != null) {
            TestUtilities.delay(durationInMilliseconds);
        }
    }

    public static boolean buildProject(IProject project) {
        boolean isSuccessful = false;
        try {
            project.build(6, null);
            isSuccessful = true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isSuccessful;
    }

    public static boolean addSourceCodeToMethod(IFile fileToAdd, String[] methodNames, String[] contents) {
        try {
            ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile((IFile)fileToAdd);
            IType mainCls = compUnit.getTypes()[0];
            IMethod[] iMethodArray = compUnit.findPrimaryType().getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                int i = 0;
                while (i < methodNames.length) {
                    if (method.getElementName().equals(methodNames[i])) {
                        method.delete(true, null);
                        mainCls.createMethod(contents[i], null, true, null);
                    }
                    ++i;
                }
                ++n2;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ILaunchConfiguration[] getConfiguration(String type) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType ctype = manager.getLaunchConfigurationType(type);
        ILaunchConfiguration[] configurations = null;
        try {
            configurations = manager.getLaunchConfigurations(ctype);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return configurations;
    }

    public static IConsoleManager getConsoleManager() {
        IConsoleManager consolemanager = ConsolePlugin.getDefault().getConsoleManager();
        consolemanager.addConsoleListener(new IConsoleListener(){

            public void consolesAdded(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    ((AbstractConsole)consoles[i]).activate();
                    ++i;
                }
            }

            public void consolesRemoved(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    ((AbstractConsole)consoles[i]).destroy();
                    ++i;
                }
            }
        });
        return consolemanager;
    }

    public static ILaunch runApplication(ILaunchConfiguration[] configurations, String name) {
        ILaunch launch = null;
        try {
            int i = 0;
            while (i < configurations.length) {
                if (configurations[i].getName().contains(name)) {
                    launch = configurations[i].launch("run", null);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return launch;
    }

    public static boolean isContainString(IConsole console, String str) {
        return ((TextConsole)console).getDocument().get().contains(str);
    }

    public static void destroy(ILaunchManager manager, IConsoleManager consoleManager) {
        if (manager != null) {
            ILaunch[] launches = manager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                ILaunch launch = launches[i];
                IProcess[] processes = launch.getProcesses();
                int j = 0;
                while (j < processes.length) {
                    try {
                        processes[j].terminate();
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (consoleManager != null) {
            consoleManager.removeConsoles(consoleManager.getConsoles());
        }
        if (manager != null) {
            ILaunchConfiguration[] configurations = null;
            try {
                configurations = manager.getLaunchConfigurations();
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            int i = 0;
            while (i < configurations.length) {
                try {
                    configurations[i].delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

