/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import junit.framework.TestCase;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WsdlGenPageTest
extends TestCase {
    private static final String TEST_WSDL_URL = "http://api.google.com/GoogleSearch.wsdl";
    private static final String BUTTON_URL = "URL";
    private static final String BUTTON_CONNECT = "Connect";
    WsdlFirstProjectWizard wizard;
    WsdlSettingPage page;
    Button backButton;
    Button nextButton;
    Button finishButton;
    Button cancelButton;
    MyWizardDialog dialog;

    protected void setUp() throws Exception {
        this.wizard = new WsdlFirstProjectWizard();
        this.page = new WsdlSettingPage("wsdlsetting");
        this.wizard.addPage((IWizardPage)this.page);
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.backButton = this.dialog.getTheButton(14);
        this.nextButton = this.dialog.getTheButton(15);
        this.finishButton = this.dialog.getTheButton(16);
        this.cancelButton = this.dialog.getTheButton(1);
    }

    protected void tearDown() throws Exception {
        this.dialog.close();
        super.tearDown();
    }

    public void testCanFlipToNextPage() throws Exception {
        WsdlGenPageTest.assertTrue((String)"can't flip to next page.", (!this.page.canFlipToNextPage() ? 1 : 0) != 0);
    }

    public void testAddButtonEnabled() {
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.rbtLocalFile.getSelection());
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.btnBrowse.getEnabled());
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.txtFilePath.getEnabled());
        WsdlGenPageTest.assertFalse((boolean)this.page.composite.rbtUrl.getSelection());
        WsdlGenPageTest.assertFalse((boolean)this.page.composite.btnFatch.getEnabled());
        WsdlGenPageTest.assertFalse((boolean)this.page.composite.txtUrl.getEnabled());
        Button btnURL = SWTUtils.getButtonInComposite((Composite)((Composite)this.page.getControl()), (String)BUTTON_URL);
        btnURL.setSelection(true);
        btnURL.notifyListeners(13, new Event());
        WsdlGenPageTest.assertFalse((boolean)this.page.composite.btnBrowse.getEnabled());
        WsdlGenPageTest.assertFalse((boolean)this.page.composite.txtFilePath.getEnabled());
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.rbtUrl.getSelection());
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.btnFatch.getEnabled());
        WsdlGenPageTest.assertTrue((boolean)this.page.composite.txtUrl.getEnabled());
    }

    public void testFatchWsdlFromURL() {
        Button btnURL = SWTUtils.getButtonInComposite((Composite)((Composite)this.page.getControl()), (String)BUTTON_URL);
        btnURL.setSelection(true);
        btnURL.notifyListeners(13, new Event());
        this.page.composite.txtUrl.setText(TEST_WSDL_URL);
        Button btnFatch = SWTUtils.getButtonInComposite((Composite)((Composite)this.page.getControl()), (String)BUTTON_CONNECT);
        btnFatch.setSelection(true);
        btnFatch.notifyListeners(13, new Event());
        WsdlGenPageTest.assertTrue((String)"should show wsdl definition", (this.page.composite.txtWsdl.getText().length() > 0 ? 1 : 0) != 0);
    }

    class MyWizardDialog
    extends WizardDialog {
        public MyWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        public Button getTheButton(int id) {
            return super.getButton(id);
        }
    }
}

