/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IServerDefinition;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;

public class ServerType
implements IServerType {
    private String mServerDef;
    private IVersion mVersion;

    public ServerType(String serverDef, IVersion version) {
        if (DeploymentExtensionManager.getInstance().getServerDefinition(serverDef) == null) {
            throw new IllegalArgumentException(DeployCorePlugin.getDefault().getResourceString("ServerType.exception.serverDefinitionDoesNotExist", new Object[]{serverDef}));
        }
        this.mServerDef = serverDef;
        this.mVersion = version;
    }

    public IServerDefinition getServerDefinition() {
        return DeploymentExtensionManager.getInstance().getServerDefinition(this.mServerDef);
    }

    public IVersion getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return DeployCorePlugin.getDefault().getResourceString("ServerType.toString", new Object[]{this.mServerDef, this.mVersion});
    }

    public boolean equals(Object obj) {
        boolean retVal;
        if (this == obj) {
            retVal = true;
        } else if (obj instanceof ServerType) {
            ServerType st = (ServerType)obj;
            retVal = this.mServerDef.equals(st.mServerDef) && this.mVersion.equals(st.mVersion);
        } else {
            retVal = false;
        }
        return retVal;
    }

    public int hashCode() {
        return this.mServerDef.hashCode();
    }
}

