package org.eclipes.stp.soas.deploy.runtime.cxf;

import java.io.File;

import org.eclipes.stp.soas.deploy.runtime.cxf.core.internal.Cxf20VersionHandler;
import org.eclipes.stp.soas.deploy.runtime.cxf.core.internal.ICxfVersionHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/**
 * The activator class controls the plug-in life cycle
 */
public class CxfRuntimePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipes.stp.soas.deploy.runtime.cxf";
	
	public static final String LOCATION_KEY = "location";

	private static final String CXF_VERSION_2_0 = ".20";
	// The shared instance
	private static CxfRuntimePlugin plugin;
	
	
	
	
	/**
	 * The constructor
	 */
	public CxfRuntimePlugin() {
		plugin = this;
	}

	
	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static CxfRuntimePlugin getDefault() {
		return plugin;
	}

    	
	public static ICxfVersionHandler getCxfVersionHandler(String id) {
//		if (id.indexOf("runtime") > 0) {
//			id = id.substring(0, 30) + id.substring(38);
//		}
		if (id.endsWith(CXF_VERSION_2_0)) {
		 	return new Cxf20VersionHandler();
		}
		return null;
	}
	
	/**
	 * Return the install location preference.
	 * 
	 * @param id a runtime type id
	 * @return the install location
	 */
	public static String getPreference(String id) {
		return "";
		//return getDefault().getPluginPreferences().getString(id);
	}
	
	/**
	 * Set the install location preference.
	 * 
	 * @param id the runtimt type id
	 * @param value the location
	 */
	public static void setPreference(String id, String value) {
		/*
		getDefault().getPluginPreferences().setValue(id, value);
		getDefault().savePluginPreferences();
		*/
	}
	
	
	/**
	 * Verify the cxf installation directory.
	 * 
	 * @param installPath
	 * @return <code>true</code> if the directory may be a Tomcat installation,
	 *    and <code>false</code> otherwise
	 */
	public static boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;
		
		String dir = installPath.toOSString();
		if (!dir.endsWith(File.separator))
			dir += File.separator;

		// look for etc path. 
		File etcDir = new File(dir + "etc");
		if (!etcDir.exists()) {
			return false;
		}
		if (!etcDir.isDirectory()) {
			return false;
		}
		return true;
	}
	
}
