/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.internal.simplefrontend;

import java.io.OutputStream;
import java.io.PrintStream;

public class SimpleWebDeployDescriptor {
    private String id;    
    private String implClsName;
    private String serviceClsName;
    private String address;

    public SimpleWebDeployDescriptor() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id=" + id);
        sb.append("implementor=" + implClsName);
        sb.append("service=" + serviceClsName); 
        sb.append("address=" + address);

        return sb.toString();
    }

    public String getEndpointName() {
        return id;
    }

    public void setEndpointName(String value) {
        this.id = value;
    }

    public String getImplClsName() {
        return implClsName;
    }

    public void setImplClsName(String value) {
        this.implClsName = value;
    }  

    public String getPattern() {
        return address;
    }

    public void setPattern(String value) {
        this.address = value;
    } 
    
    public String getServiceClsName() {
        return serviceClsName;
    }

    public void setServiceClsName(String value) {
        this.serviceClsName = value;
    }

    public void serizlize(OutputStream os) {
        PrintStream ps = new PrintStream(os);
        ps.println("<simple:server");
        ps.println("    id=\"" + id + "_xml_bare" + "\"");
        if(serviceClsName != null){
        	ps.println("    serviceClass=\"" + serviceClsName + "\"");
        }
        ps.println("    address=\"/" + address + "\" >");
        ps.println("       <simple:serviceBean>");
        ps.println("            <bean class=\"" + implClsName + "\"/>");
        ps.println("       </simple:serviceBean>");
        ps.println("</simple:server>");
        ps.flush();
    }
}
