package org.eclipes.stp.soas.deploy.runtime.jaxwsri;

import java.io.File;

import org.eclipes.stp.soas.deploy.runtime.jaxwsri.core.internal.JaxwsRI21VersionHandler;
import org.eclipes.stp.soas.deploy.runtime.jaxwsri.core.internal.IJaxwsRIVersionHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/**
 * The activator class controls the plug-in life cycle
 */
public class JaxwsRIRuntimePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipes.stp.soas.deploy.runtime.jaxwsri";
	
	public static final String LOCATION_KEY = "location";

	private static final String RI_VERSION_2_1_2 = ".212";
	// The shared instance
	private static JaxwsRIRuntimePlugin plugin;
	
	
	
	
	/**
	 * The constructor
	 */
	public JaxwsRIRuntimePlugin() {
		plugin = this;
	}

	
	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static JaxwsRIRuntimePlugin getDefault() {
		return plugin;
	}

    	
	public static IJaxwsRIVersionHandler getRIVersionHandler(String id) {
		if (id.endsWith(RI_VERSION_2_1_2)) {
		 	return new JaxwsRI21VersionHandler();
		}
		return null;
	}
	
	/**
	 * Return the install location preference.
	 * 
	 * @param id a runtime type id
	 * @return the install location
	 */
	public static String getPreference(String id) {
		return "";
		//return getDefault().getPluginPreferences().getString(id);
	}
	
	/**
	 * Set the install location preference.
	 * 
	 * @param id the runtimt type id
	 * @param value the location
	 */
	public static void setPreference(String id, String value) {
		/*
		getDefault().getPluginPreferences().setValue(id, value);
		getDefault().savePluginPreferences();
		*/
	}
	
	
	/**
	 * Verify the ri installation directory.
	 * 
	 * @param installPath
	 * @return <code>true</code> if the directory may be a RI installation,
	 *    and <code>false</code> otherwise
	 */
	public static boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;
		
		String dir = installPath.toOSString();
		if (!dir.endsWith(File.separator))
			dir += File.separator;

		// look for /bin/wsgen 
		File wsgen = new File(dir + "bin" + File.separator + "wsgen.bat");
		if (!wsgen.exists()) {
			return false;
		}
        // look for /bin/wsimport 
		File wsimport = new File(dir + "bin" + File.separator + "wsimport.bat");
		if (!wsimport.exists()) {
			return false;
		}
		return true;
	}
	
}
