/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.parts.NonVisualComponentEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;

public class HTMLEditPartsFactory
implements EditPartFactory {
    private IDOMDocument _destDocument;

    public HTMLEditPartsFactory(IDOMDocument destDoc) {
        this._destDocument = destDoc;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        NodeEditPart part = null;
        if (model instanceof Node) {
            Node node = (Node)model;
            if (node.getNodeType() == 9) {
                part = new DocumentEditPart();
            } else if (node.getNodeType() == 1) {
                part = new ElementEditPart();
            } else if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                part = new TextEditPart();
            }
        } else if (model instanceof ITagConverter) {
            part = new NonVisualComponentEditPart();
        }
        if (part != null) {
            part.setDestDocumentForDesign(this._destDocument);
            part.setModel(model);
        }
        return part;
    }
}

