/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.InferredGrammarBuildingCMDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewerActionBarContributor;
import org.eclipse.wst.xml.ui.internal.tabletree.ViewerExpandCollapseAction;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.w3c.dom.Document;

public class XMLTableTreeActionBarContributor
implements IDesignViewerActionBarContributor {
    protected IEditorPart editorPart;
    protected static final String DESIGN_VIEWER_SEPARATOR_1_ID = "sed.tabletree.separator.1";
    protected static final String DESIGN_VIEWER_SEPARATOR_2_ID = "sed.tabletree.separator.2";
    protected static final String VALIDATE_XML_ID = "sed.tabletree.validateXML";
    protected static final String RELOAD_GRAMMAR_ID = "sed.tabletree.reloadGrammar";
    protected static final String TOGGLE_EDIT_MODE_ID = "sed.tabletree.toggleEditMode";
    protected static final String EXPAND_ALL_ID = "sed.tabletree.expandAll";
    protected static final String COLLAPSE_ALL_ID = "sed.tabletree.collapseAll";
    protected ToggleEditModeAction toggleAction;
    protected ReloadGrammarAction reloadGrammarAction;
    protected ViewerExpandCollapseAction expandAction;
    protected ViewerExpandCollapseAction collapseAction;
    protected ViewerExpandCollapseAction xmlMenuExpandAction;
    protected ViewerExpandCollapseAction xmlMenuCollapseAction;
    static /* synthetic */ Class class$0;

    protected void removeContributions(IContributionManager manager) {
        try {
            this.doRemove(manager, DESIGN_VIEWER_SEPARATOR_1_ID);
            this.doRemove(manager, DESIGN_VIEWER_SEPARATOR_2_ID);
            this.doRemove(manager, VALIDATE_XML_ID);
            this.doRemove(manager, RELOAD_GRAMMAR_ID);
            this.doRemove(manager, TOGGLE_EDIT_MODE_ID);
            this.doRemove(manager, EXPAND_ALL_ID);
            this.doRemove(manager, COLLAPSE_ALL_ID);
        }
        catch (Exception exception) {}
    }

    protected void doRemove(IContributionManager manager, String id) {
        try {
            if (manager.find(id) != null) {
                manager.remove(id);
            }
        }
        catch (Exception exception) {}
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.init(bars);
    }

    public void init(IActionBars bars) {
        IToolBarManager tbm = bars.getToolBarManager();
        IMenuManager xmlMenu = bars.getMenuManager().findMenuUsingPath("org.eclipse.core.runtime.xml.design.xmlmenu");
        if (xmlMenu == null) {
            xmlMenu = new MenuManager(XMLEditorMessages.XMLTableTreeActionBarContributor_0, "org.eclipse.core.runtime.xml.design.xmlmenu");
            bars.getMenuManager().insertBefore("window", (IContributionItem)xmlMenu);
        } else {
            this.removeContributions((IContributionManager)xmlMenu);
        }
        tbm.add((IContributionItem)new Separator("DESIGN_VIEWER_SEPARATOR_1_ID"));
        this.toggleAction = new ToggleEditModeAction();
        this.toggleAction.setId(TOGGLE_EDIT_MODE_ID);
        xmlMenu.add((IAction)this.toggleAction);
        tbm.add((IAction)this.toggleAction);
        this.reloadGrammarAction = new ReloadGrammarAction();
        this.reloadGrammarAction.setId(RELOAD_GRAMMAR_ID);
        tbm.add((IAction)this.reloadGrammarAction);
        xmlMenu.add((IAction)this.reloadGrammarAction);
        xmlMenu.add((IContributionItem)new Separator());
        this.xmlMenuExpandAction = new ViewerExpandCollapseAction(true);
        this.xmlMenuExpandAction.setId(EXPAND_ALL_ID);
        this.xmlMenuExpandAction.setText(XMLEditorMessages.XMLTableTreeActionBarContributor_1);
        xmlMenu.add((IAction)this.xmlMenuExpandAction);
        this.xmlMenuCollapseAction = new ViewerExpandCollapseAction(false);
        this.xmlMenuCollapseAction.setId(COLLAPSE_ALL_ID);
        this.xmlMenuCollapseAction.setId(EXPAND_ALL_ID);
        this.xmlMenuCollapseAction.setText(XMLEditorMessages.XMLTableTreeActionBarContributor_2);
        xmlMenu.add((IAction)this.xmlMenuCollapseAction);
    }

    protected void addActionWithId(IMenuManager menuManager, Action action, String id) {
        action.setId(id);
        menuManager.add((IAction)action);
    }

    public void initViewerSpecificContributions(IActionBars bars) {
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add((IContributionItem)new Separator(DESIGN_VIEWER_SEPARATOR_2_ID));
        this.expandAction = new ViewerExpandCollapseAction(true);
        this.expandAction.setId(EXPAND_ALL_ID);
        tbm.add((IAction)this.expandAction);
        this.collapseAction = new ViewerExpandCollapseAction(false);
        this.collapseAction.setId(COLLAPSE_ALL_ID);
        tbm.add((IAction)this.collapseAction);
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        if (this.expandAction != null) {
            this.expandAction.setEnabled(enabled);
            this.xmlMenuExpandAction.setEnabled(enabled);
        }
        if (this.collapseAction != null) {
            this.collapseAction.setEnabled(enabled);
            this.xmlMenuCollapseAction.setEnabled(enabled);
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IWorkbenchPartSite site;
        this.editorPart = targetEditor;
        IStructuredModel model = this.getModelForEditorPart(targetEditor);
        this.reloadGrammarAction.setModel(model);
        this.toggleAction.setModelQuery(ModelQueryUtil.getModelQuery((IStructuredModel)model));
        XMLTableTreeViewer tableTreeViewer = this.getTableTreeViewerForEditorPart(this.editorPart);
        if (tableTreeViewer != null) {
            this.expandAction.setViewer((AbstractTreeViewer)tableTreeViewer);
            this.collapseAction.setViewer((AbstractTreeViewer)tableTreeViewer);
            this.xmlMenuExpandAction.setViewer((AbstractTreeViewer)tableTreeViewer);
            this.xmlMenuCollapseAction.setViewer((AbstractTreeViewer)tableTreeViewer);
        }
        if (this.editorPart instanceof XMLMultiPageEditorPart && (site = this.editorPart.getSite()) instanceof IEditorSite) {
            StructuredTextEditor textEditor = ((XMLMultiPageEditorPart)this.editorPart).getTextEditor();
            IActionBars actionBars = ((IEditorSite)site).getActionBars();
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.getAction((ITextEditor)textEditor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.getAction((ITextEditor)textEditor, ITextEditorActionConstants.REDO));
        }
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null ? null : editor.getAction(actionId);
    }

    protected IStructuredModel getModelForEditorPart(IEditorPart targetEditor) {
        IStructuredModel result = null;
        if (this.editorPart instanceof XMLMultiPageEditorPart) {
            StructuredTextEditor textEditor = ((XMLMultiPageEditorPart)targetEditor).getTextEditor();
            result = textEditor != null ? textEditor.getModel() : null;
        }
        return result;
    }

    protected XMLTableTreeViewer getTableTreeViewerForEditorPart(IEditorPart targetEditor) {
        Object object;
        XMLTableTreeViewer result = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = targetEditor.getAdapter((Class)clazz)) instanceof XMLTableTreeViewer) {
            result = (XMLTableTreeViewer)object;
        }
        return result;
    }

    public void dispose() {
    }

    public class ReloadGrammarAction
    extends Action {
        protected IStructuredModel model;

        public ReloadGrammarAction() {
            this.setDisabledImageDescriptor(SharedXMLEditorPluginImageHelper.getImageDescriptor("icons/full/dtool16/rldgrmr.gif"));
            this.setImageDescriptor(SharedXMLEditorPluginImageHelper.getImageDescriptor("icons/full/etool16/rldgrmr.gif"));
            this.setToolTipText(XMLEditorMessages.XMLTableTreeActionBarContributor_7);
            this.setText(XMLEditorMessages.XMLTableTreeActionBarContributor_8);
        }

        public void setModel(IStructuredModel newModel) {
            this.model = newModel;
        }

        public void run() {
            if (this.model != null) {
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)this.model);
                IDOMDocument document = ((IDOMModel)this.model).getDocument();
                if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
                    modelQuery.getCMDocumentManager().getCMDocumentCache().clear();
                    InferredGrammarBuildingCMDocumentLoader loader = new InferredGrammarBuildingCMDocumentLoader((Document)document, modelQuery);
                    loader.loadCMDocuments();
                }
            }
        }
    }

    public class ToggleEditModeAction
    extends Action {
        protected ImageDescriptor onImage = SharedXMLEditorPluginImageHelper.getImageDescriptor("icons/full/etool16/constrainon.gif");
        protected ImageDescriptor offImage = SharedXMLEditorPluginImageHelper.getImageDescriptor("icons/full/etool16/constrainoff.gif");
        protected ModelQuery modelQuery;

        public ToggleEditModeAction() {
            this.setAppearanceForEditMode(2);
        }

        public void run() {
            if (this.modelQuery != null) {
                int newState = this.getNextState(this.modelQuery.getEditMode());
                this.modelQuery.setEditMode(newState);
                this.setAppearanceForEditMode(newState);
            }
        }

        public void setModelQuery(ModelQuery newModelQuery) {
            this.modelQuery = newModelQuery;
            if (this.modelQuery != null) {
                this.setAppearanceForEditMode(this.modelQuery.getEditMode());
            }
        }

        public void setAppearanceForEditMode(int editMode) {
            if (editMode == 2) {
                this.setToolTipText(XMLEditorMessages.XMLTableTreeActionBarContributor_3);
                this.setText(XMLEditorMessages.XMLTableTreeActionBarContributor_4);
                this.setImageDescriptor(this.onImage);
            } else {
                this.setToolTipText(XMLEditorMessages.XMLTableTreeActionBarContributor_5);
                this.setText(XMLEditorMessages.XMLTableTreeActionBarContributor_6);
                this.setImageDescriptor(this.offImage);
            }
        }

        public int getNextState(int editMode) {
            int result = -1;
            result = editMode == 2 ? 0 : 2;
            return result;
        }
    }
}

